package gui.html;

import gui.ClosableJFrame;

import javax.swing.*;


public class HtmlViewer extends ClosableJFrame {
    private JEditorPane htmlPane
            = new JEditorPane();
    private JEditorPane textPane
            = new JEditorPane();

    public HtmlViewer() {
        super("HtmlViewer");
        java.awt.Container c = getContentPane();
        c.setLayout(new java.awt.GridLayout(0,1));
        c.add(new javax.swing.JScrollPane(htmlPane));
        //c.add(new javax.swing.JScrollPane(textPane));
        setSize(400, 400);
        setVisible(true);
    }

    public void setHtml(String s) {
        htmlPane.setContentType("text/html");
        htmlPane.setText(s);
    }

    public void setRtfText(String s) {
        textPane.setContentType("text/rtf");
        textPane.setText(s);
    }

    public void setPlainText(String s) {
        textPane.setContentType("text/plain");
        textPane.setText(s);
    }

    public void setString(String s) {
        setPlainText(s);
        setHtml(s);
        System.out.println(s);
    }

    public static void main(String args[]) {
        HtmlViewer hv = new HtmlViewer();
        HtmlSynthesizer hs = new HtmlSynthesizer();
        hv.setString(hs.testForm2());
    }
}