package gui.html;

import futils.Futil;
import futils.Ls;
import futils.ReaderUtil;
import futils.WriterUtil;

import java.io.*;
import java.util.StringTokenizer;

/**
 @author D. Lyon
 @version 1.1
 @see HtmlUtil
 */
public class HtmlUtil {


    private static void makeLinks() {
        File f = Futil.getReadFile("select a bookmarks file");
        BufferedReader br = ReaderUtil.getBufferedReader(f);
        FileWriter fw = WriterUtil.getFileWriter("Enter file.gui.html");
        PrintWriter pw = new PrintWriter(fw);
        String link;
        String line = null;
        // creating gui.html writeHeader for the output file
        String head =
                "<HTML> \n <BODY>\n <B><I>"
                + " Following HyperLinks are extracted from "
                + f + " <B><I><P>";
        // write the gui.html writeHeader
        pw.println(head);

        while (((line = ReaderUtil.readLine(br)) != null)) {
            link = getHyperLink(line);
            // extract the hyperlink from the line read from the input file
            if (link != null)
                pw.println("<LI><A HREF =\"" + link + "\">" + link + "</A><P>");

        }
        pw.println("</BODY> \n </HTML>");
        WriterUtil.close(fw);
    }

    /**
     * getHyperLink() - extract the hyperlinks from the line
     *
     *@param String - line from  the input file
     *
     *@return String - return the extracted hyperlink from the line
     */
    public static String getHyperLink(String l) {
        String link;
        StringTokenizer st = new StringTokenizer(l, "\"");
        int tc = st.countTokens();
        for (int i = 0; i < tc; i++) {
            String s = st.nextToken();
            if (s.indexOf("http") == 0) {
                return s;
            }
        }
        return null;
    }

    public static void main(String args[]) {
        HtmlUtil.makeLinks();
        System.out.println("done");
    }

    static public void filterHtmls() {
        File files[] = Ls.getWildFiles(".gui.html");
        File input_dir = Futil.getReadFile("select an gui.html file");
        System.out.println(files.length +
                " file(s) to process");

        File output_dir = new File(input_dir.getParent(), "out");
        if (output_dir.exists())
            System.out.println("Output dir exists:" +
                    output_dir);
        else
            output_dir.mkdir();

        //for (int i=0; i < files.length; i++)
        //	 		writeFilteredHrefFile(
        //	 			input_dir+files[i],
        //	 			output_dir+
        //	 			"/"+
        //	 			files[i]);

    }

    public static void writeFilteredHrefFile()
            throws IOException {
        FileReader fr = ReaderUtil.getFileReader("select an gui.html file");
        StreamTokenizer st =
                new StreamTokenizer(fr);


        FileWriter fw = WriterUtil.getFileWriter("select an HTML file for output");
        PrintWriter pw = new PrintWriter(fw);
        int i;
        int next = 0;
        st.resetSyntax();
        st.wordChars(0, 255);
        st.quoteChar('"');
        while ((next = st.nextToken()) !=
                StreamTokenizer.TT_EOF) {
            switch (next) {
                case '"':
                    pw.print('"');
                    for (i = 0; i <
                            st.sval.length(); i++)
                        if (st.sval.charAt(i) ==
                                ' ')
                            pw.print("%20");
                        else
                            pw.print(st.sval.charAt(i));
                    pw.print('"');
                    break;
                case StreamTokenizer.TT_WORD:
                    pw.print(st.sval + " ");
                    break;
                case StreamTokenizer.TT_NUMBER:
                    pw.print(st.nval + " ");
                    break;
                case StreamTokenizer.TT_EOL:
                    pw.println();
                    break;
            } // end switch
        } // end while
        WriterUtil.close(fw);
        ReaderUtil.close(fr);
    }

    public static void writeFilteredJavaFile() {
        try {
            FileReader is = ReaderUtil.getFileReader("select a java file");
            StreamTokenizer tokens = new StreamTokenizer(is);

            PrintStream output = System.out;
            int next = 0;
            tokens.resetSyntax();
            tokens.wordChars(0, 255);
            tokens.quoteChar(';');
            while ((next = tokens.nextToken()) !=
                    StreamTokenizer.TT_EOF) {
                switch (next) {
                    case ';':

                        output.print("got a line:" +
                                tokens.lineno());
                        break;
                    case StreamTokenizer.TT_WORD:
                        output.print(tokens.sval +
                                " ");
                        break;
                    case StreamTokenizer.TT_NUMBER:
                        output.print(tokens.nval +
                                " ");
                        break;
                    case StreamTokenizer.TT_EOL:
                        output.println();
                        break;
                } // end switch
            } // end while
            is.close();
        } // end try
        catch (Exception exe) {
            System.out.println("writeFilteredHrefFile:er!");
        }
    }

    /**
     * Inputs an gui.html file and uses %20 where spaces are seen in the
     * hrefs.
     */
    public static void filterFileHrefs()
            throws IOException {
        FileReader fis = ReaderUtil.getFileReader("select an gui.html file");
        StreamTokenizer tokens = new StreamTokenizer(fis);
        int next = 0;
        tokens.resetSyntax();
        tokens.wordChars(0, 255);
        tokens.quoteChar('"');

        while ((next = tokens.nextToken())
                != StreamTokenizer.TT_EOF) {
            switch (next) {
                case '"':
                    System.out.print('"');
                    StringTokenizer st =
                            new StringTokenizer(tokens.sval,
                                    " ");
                    while (st.hasMoreTokens()) {
                        System.out.print(st.nextToken());
                        if (st.countTokens() > 1) {
                            System.out.print("%20");
                        }
                    }
                    System.out.print('"');
                    break;
                case StreamTokenizer.TT_WORD:
                    System.out.print(tokens.sval + " ");
                    break;
                case StreamTokenizer.TT_NUMBER:
                    System.out.print(tokens.nval + " ");
                    break;
                case StreamTokenizer.TT_EOL:
                    System.out.println();
                    break;
            } // switch
        }
        System.out.println();
        ReaderUtil.close(fis);
    }

    public static void processJava() {
        FileReader fis = ReaderUtil.getFileReader("select a java file");
        String line;
        BufferedReader dis = new BufferedReader(fis);
        System.out.println("<HTML><BODY><PRE>");
        try {
            while ((line = dis.readLine()) !=
                    null)
                System.out.println(line);
        } catch (IOException e) {
            System.out.println("Futil: ER! in processJava");
        }
        System.out.println("</PRE></BODY></HTML>");
        ReaderUtil.close(fis);
    }

    public static void listFilteredHrefFile(String file) {
        System.out.println("processing:\t" + file);
        try {
            FileInputStream is = new
                    FileInputStream(file);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            StreamTokenizer tokens = new StreamTokenizer(br);
            int next = 0;
            tokens.resetSyntax();
            tokens.wordChars(0, 255);
            tokens.quoteChar('"');
            while ((next = tokens.nextToken()) !=
                    StreamTokenizer.TT_EOF) {
                switch (next) {
                    case '"':
                        System.out.print('"');
                        StringTokenizer st =
                                new StringTokenizer(tokens.sval,
                                        " ");
                        while (st.hasMoreTokens()) {
                            System.out.print(st.nextToken());
                            if (st.countTokens() >
                                    1) {
                                System.out.print("%20");
                            }
                        }
                        System.out.print('"');
                        break;
                    case StreamTokenizer.TT_WORD:
                        System.out.print(tokens.sval +
                                " ");
                        break;
                    case StreamTokenizer.TT_NUMBER:
                        System.out.print(tokens.nval +
                                " ");
                        break;
                    case StreamTokenizer.TT_EOL:
                        System.out.println();
                        break;
                }
            }
            System.out.println();
            Futil.close(is);
        } catch (Exception exe) {
            System.out.println("listFilteredHrefFile:er!");
        }
    }
}
