package gui.html;

import javax.swing.*;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import java.net.URL;

public class BrowserListener
        implements HyperlinkListener {
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() ==
                HyperlinkEvent.EventType.ACTIVATED) {
            processActivated(e);
        }
    }

    private void processActivated(HyperlinkEvent e) {
        JEditorPane jep =
                (JEditorPane) e.getSource();
        if (e instanceof HTMLFrameHyperlinkEvent)
            processHyperLinkEvent(e, jep);
        else {
            setPage(jep, e);
        }
    }

    private void setPage(JEditorPane jep,
                         HyperlinkEvent e) {
        URL url = e.getURL();
        System.out.println(url);
        try {
            jep.setPage(url);
        } catch (Throwable t) {
            System.out.println("could not open:" +
                    url);
            //jep.setText(net.Browser.toString(url+""));
            //t.printStackTrace();
        }
    }


    private void processHyperLinkEvent(
            HyperlinkEvent e, JEditorPane pane) {
        HTMLFrameHyperlinkEvent hle =
                (HTMLFrameHyperlinkEvent) e;
        HTMLDocument htmlDoc = (HTMLDocument) pane.getDocument();
        htmlDoc.processHTMLFrameHyperlinkEvent(hle);
    }
}
