package gui.componentEditor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;


public class CommandLineInterpreter {

    public static String getString(String prompt) {
        return javax.swing.JOptionPane.showInputDialog(prompt);
    }

    public static String[] getStrings(String commandLine) {
        StringTokenizer st = new StringTokenizer(commandLine, " ");
        int n = st.countTokens();
        String s[] = new String[n];
        for (int i = 0; i < n; i++) {
            s[i] = st.nextToken();
        }
        return s;
    }

    public static void executeTheCommandLine(String s[])
            throws ClassNotFoundException, InvocationTargetException,
            IllegalAccessException, InstantiationException {
        String className = s[0];
        Class c = Class.forName(className);
        //System.out.println(c);

        Method mainMethod = getMainMethod(c);
        //System.out.println("mainMethod = " + mainMethod);
        String args[][] = new String[1][s.length - 1];
        for (int i = 0; i < args[0].length; i++) {
            args[0][i] = s[i + 1];
            //System.out.println("args["+i+"]="+args[0][i]);
        }
        mainMethod.invoke(null, args);
    }


    public static Method getMainMethod(Class c) {
        Method ma[] = c.getMethods();
        for (int i = 0; i < ma.length; i++) {
            //System.out.println("ma[" + i + "] = " + ma[i].getName());
            if (ma[i].getName().equals("main"))
                return ma[i];
        }
        return null;
    }

    public static void main(String args[]) {
        while (true) {
            try {
                String s[] = getStrings(
                        getString("command:"));
                executeTheCommandLine(s);
            } catch (ClassNotFoundException e) {
                System.out.println("ER!");
            } catch (InvocationTargetException e) {
            } catch (IllegalAccessException e) {
            } catch (InstantiationException e) {
            }
        }
    }

}