package gui.browser;


public class HtmlSynthesizer {
    private String imageHome = "d:\\images\\";

    public void print(double x) {
        System.out.println(x);
    }

    public void print(String s) {
        System.out.println(s);
    }

    public String getHtml(String s) {
        return "<gui.html>\n" + s + "\n</gui.html>";
    }

    public String getHomePage() {
        return "<a href=\"http://www.docjava.com\">home</a>\n";
    }

    public String getHomePage(int n) {
        String s = getHomePage();
        for (int i = 0; i < n; i++)
            s = s + getHomePage();
        return s;
    }

    public String getListItem(String s) {
        return "<li>\n" + s + "\n</li>";
    }

    public String getBreak() {
        return "\n<br>\n ";
    }

    public String getH1(String s) {
        return "<h1>\n" + s + "\n</h1>";
    }

    public String getSubmit() {
        return
                "<input type=submit"
                + " value=" + quote("submit") + ">\n";
    }

    public String getOption(String s) {
        return "\t<option value=" + s + " >" + s + '\n';
    }

    public String getSelect(String name, String options[]) {
        String s = "";
        ;
        for (int i = 0; i < options.length; i++)
            s = s + getOption(options[i]);
        return "<select name=" + name + ">" + s + "</select>";
    }

    public String getSelect(String name) {
        String sn [] = {"1", "2", "3", "4", "5"};
        return getSelect(name, sn);
    }

    public String getH2(String s) {
        return "<h2>\n" + s + "\n</h2>";
    }

    public String getH3(String s) {
        return "<h3>\n" + s + "\n</h3>";
    }

    public String getH4(String s) {
        return "<h4>\n" + s + "\n</h4>";
    }

    public String getH5(String s) {
        return "<h5>\n" + s + "\n</h5>";
    }

    public String getH6(String s) {
        return "<h6>\n" + s + "\n</h6>";
    }

    public String getP(String s) {
        return "<p>\n" + s + "\n</p>";
    }

    /**
     * <code>getBody</code> sets the background color to white.
     * It would be really nice if the background color were decoded
     * from an instance of the <code>Color</code> class.
     */

    public String getBody(String s) {
        return "<body BGCOLOR=\"#FFFFFF\">\n" + s + "\n</body>";
    }

    public String getHead(String s) {
        return "<Head>\n" + s + "\n</Head>\n";
    }

    public String getTitle(String s) {
        return "<title>\n" + s + "\n</title>\n";
    }

    public String getCaption(String s) {
        return
                "<caption>"
                + s
                + "</caption>";
    }

    public String getTr(String s) {
        return "<tr>" + s + "</tr>\n";
    }
    //<td width="91" height="39">c11</td>

    public String getTd(int w, int h, String s) {
        return "\n\t<td width=\""
                + w
                + "\" height=\"" + h + "\">"
                + s +
                "</td>\n";
    }

    public String getTd(String s) {
        return "\n\t<td>"
                + s +
                "</td>\n";
    }

    public String getTd(String s1, String s2, String s3, String s4) {
        return "\n\t<td>"
                + s1 + quote(s2) + s3 + s4
                + "</td>\n";
    }


    public String getRow(int r, int nc) {
        String s = "";
        for (int c = 1; c <= nc; c++)
            s = s + getTd(r + "," + c + " ");
        return s;

    }

    public String getSheet(String a[][]) {
        String s = "";
        for (int i = 0; i < a.length; i++) {
            s = "<tr>" + s;
            for (int j = 0; j < a[i].length; j++) {
                s = s + getTd(a[i][j]);
            }
            s = s + "</tr><p>\n";
        }
        return s;
    }

    public String getTable(String s) {
        return "\n<table border=1>\n" + s + "\n</table>\n";
    }

    public String getInput(
            String type,
            String name,
            String value,
            int size) {
        return
                "\n<input type=" + quote(type)
                + "name=" + quote(name)
                + " value=" + quote(value)
                + "size=" + size
                + ">\n";
    }

    public String getImage(String imageName, String altStr) {
        return "<img src="
                + quote(imageName)
                + "alt=" + quote(altStr)
                + ">";

    }

    public String getImage(String imageName) {
        return "<img src="
                + quote(imageName)
                + "alt=" + quote(imageName)
                + ">";

    }

    public String getInput(
            String type,
            String name,
            String value) {
        return
                "\n<input type=" + type + ' '
                + "name=" + name
                + " value=" + value
                + " >";
    }
    // <input type="radio" name="B1_Rating" value="Excellent">

    public String getRadio(String name, String value) {
        return
                getInput("radio", name, value) + value;
    }

    /** <code><input type="checkbox" name="B1_Rating" value="true" checked></code>
     *     returns the gui.html for a check box that is checked if b is true.
     */

    public String getCheckbox(String name, boolean b) {
        return
                getInput("checkbox", name, b ? "\"true\" CHECKED" : "\"false\"");
    }

    //<INPUT TYPE="text" NAME="UID" VALUE="" SIZE=30>
    public String getTextField(String name, String value, int size) {
        return
                getInput("text", name, value, 30);
    }

    public String getRadioButtons(String name, int b) {
        String s = "";
        for (int i = 1; i <= b; i++)
            s = s + getRadio(name, i + "");
        return "<p>" + s + "";
    }

    public String getPassField(String name, String value, int size) {
        return
                getInput("password", name, value, 30);
    }

    public String getTextField(String name, String value) {
        return
                getTextField(name, value, 30);
    }

    public String getPassField(String name, String value) {
        return
                getPassField(name, value, 30);
    }

    public String getPassField(String name) {
        return
                getPassField(name, "", 30);
    }

    public String getTextField(String name) {
        return
                getTextField(name, "", 30);
    }

    //<FORM action="" method="POST">
    public String getForm(String action, String method, String s) {
        return "\n<form action=" + quote(action)
                + "method=" + quote(method) + ">\n"
                + s + ' '
                + "\n </form >\n";
    }

    public String quote(String s) {
        return '\"' + s + "\" ";
    }

    public String getTable(int nr, int nc) {
        String s = "<TABLE BORDER=1>";
        for (int r = 1; r <= nr; r++) {
            s = s +
                    getTr(getRow(r, nc));
            // assume number of columns is the
            // same for each row
        }
        return s + "</table>";
    }

    public String testForm1() {
        return
                getHtml(
                        getHead(getTitle("testForm")) +
                getBody(
                        getForm("", "GET",
                                getP(getTextField("name")) +
                getPassField("password") +
                getRadioButtons("q1", 5)

                        )
                )
                );
    }

    public String[] getSelects(String name, int n) {
        String s[] = new String[n];
        s[0] = name;
        for (int i = 1; i < n; i++)
            s[i] = getSelect(name);
        return s;
    }

    public String testForm() {

        String a [][] = {
            {"Student Name", "Analytic Skills",
             "Communication Skills",
             "creative problem solving"},
            getSelects("doe", 4),
            getSelects("shmoe", 4),
            getSelects("wanker", 4),
            getSelects("spanker", 4),
            getSelects("peabody", 4),
        };
        return
                getHtml(
                        getHead(
                                getTitle(
                                        "my title!")) +
                getBody(
                        getHomePage(10) +
                getForm(
                        "http://localhost/examples/servlet/HelloWorldExample",
                        "GET",
                        getTable(
                                getCaption("My Caption")
                + getSheet(a))
                + getSubmit()
                + getImage(
                        "http://www.docjava.com/consulti/docjava.jpe")

                )
                )
                );
    }

    public String loadHomePage() {

        return
                getHtml(
                        getHead(
                                getTitle(
                                        "DocJava Home Page")) +
                getBody(
                        getHomePage(0) +
                getForm("http://www.docjava.com",
                        "GET",
                        getTable(
                                getTr(
                                        getTd("<a href=", "http://www.willcam.com/cmat/gui.html/crossname.gui.html",
                                                "> ", "Comprehensive HTML Cross Reference</a>"))
                + getTr(
                        getTd("<a href=", "http://www.lynda.com/hexh.gui.html",
                                "> ", "Lynda's color chart</a>"))
                + getTr(
                        getTd("<a href=", "http://www.zdnet.com/devhead/resources/href/ascii.gui.html",
                                "> ", "ASCII Character Chart</a>"))
                + getTr(
                        getTd("<a href=", "http://java.sun.com/docs/books/tutorial/index.gui.html",
                                "> ", "Java Tutorial</a>"))
                + getTr(
                        getTd("<a href=", "http://java.sun.com/docs/books/tutorial/uiswing/components/toolbar.gui.html",
                                "> ", "How to use Tool Bars</a>"))
                        )
                )
                )
                );
    }


    public static void main(String args[]) {
        HtmlSynthesizer hs = new HtmlSynthesizer();
        System.out.println(
                hs.getHtml(
                        hs.getForm("", "GET",
                                hs.getTextField("name")) +
                hs.getTable(9, 20)));
    }
}