package gui;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jan 8, 2005
 * <p/>
 * Time: 1:10:47 PM
 */
public class DateUtils {
    public static final String SIMPLE_DATE_PATTERN = "M/d/yy";
    public static final SimpleDateFormat SIMPLE_DATE_FORMAT =
            new SimpleDateFormat(SIMPLE_DATE_PATTERN);


    /**
     * Input a simple date in M/d/yy format.
     * Performs error correction with a modal dialog.
     * returns todays date if there is an error.
     * @param s
     * @return
     */
    public static Date getSimpleDate(String s) {
        DateFormat df = SIMPLE_DATE_FORMAT;
        try {
            return df.parse(s);
        } catch (ParseException e) {
            return new Date();
        }

    }
    public static Date getDate(Date d){
        DateFormat df = SIMPLE_DATE_FORMAT;
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(d);
        String s = df.format(gc.getTime());
        s = In.getString("enter date:"+s);
        try {
            return df.parse(s);
        }catch(ParseException e){
            In.alert("improper format, try again");
            return getDate(d);
        }

    }
}
