package graphics.raytracers.tracer.primatives;

import graphics.raytracers.tracer.geometry.Ray3d;
import graphics.raytracers.tracer.geometry.Vector3d;

public abstract class Primitive {
    public Surface surf = new Surface();

    public void setColor(double r, double g, double b) {
        surf.color = new Vector3d(r, g, b);
    }

    public abstract Vector3d normal(Vector3d pnt);

    public abstract Isect intersect(Ray3d ry);

    public abstract String toString();
}
