package graphics.raytracers.rmiRaytracer.raytracer;

import java.awt.*;
import java.util.Vector;

// graphics.raytracer.Main

public class Main {

    public static void main(String args []) {
        int size = 100;
        int increment = 50;
        for (int i = 0; i < size; i = i + increment) {
            System.out.println("i=" + i);
            //RayFrame rf = new RayFrame(
            //	new Dimension(i,i+increment),size);

            asynchronousLaunch(i, increment, size);
        }


    }

    public static void asynchronousLaunch(
            final int i,
            final int increment, final int size) {
        Runnable r = new Runnable() {
            public void run() {
                long start = System.currentTimeMillis();
                new RayFrame(new Dimension(i, i + increment), size);
                long end = System.currentTimeMillis();
                double time = (end - start) / 1000.0;

                System.out.println("done! in:" + time + " seconds");
            }
        };
        Thread t = new Thread(r);
        t.start();
    }
}


class PolygonTarget implements Target {
    Vector vertexList;
    Vec planeNormal;
    static Targets scene;

    public PolygonTarget() {
    }

    public PolygonTarget(Vector vl, Vec pn) {
        planeNormal = new Vec(pn);
        vertexList = (Vector) vl.clone();
    }

    public double intersectTest(Vec R0, Vec R1, int object) {
        System.out.println("Polygon intersect Test");
        return 0.0;
    }

    public int shade(int object, Vec R1, double t[]) {
        return 0;
    }

    public void debug_test() {
        System.out.println("PolygonTarget.debug_test():");
    }

    public void setScene(Targets s) {
    }

    public boolean isBelongingToScene() {
        return false;
    }
}

