package graphics.graph;

import java.awt.*;

public class NodeDrawer
        /**
         *	The responsibility of this class is to
         *	draw the nodes onto a Graphics interface.
         */ {
    private PickBean pb = PickBean.getPickBean();
    private ColorPanel cp = GraphFactory.getColorPanel();
    private Nodes nodes = GraphFactory.getNodes();

    private Color getColor(Node n) {
        return (n == pb.getPick())
                ? cp.getSelectColor() : (n.isFixed()
                ? cp.getFixedColor() : cp.getNodeColor());
    }

    private void paintNode(Graphics g, Node n) {
        g.setColor(getColor(n));
        n.draw(g);
    }

    public void drawNodes(ImageBuffer ui) {
        for (int i = 0; i < nodes.getNumberOfNodes(); i++)
            paintNode(ui.getOffGraphics(), nodes.getNode(i));
    }
}