package graphics.graph;

import java.util.Vector;

public class EdgesBean {
    private static EdgesBean eb = new EdgesBean();
    private Nodes nodes = GraphFactory.getNodes();

    private EdgesBean() {
    }

    public static EdgesBean getEdgesBean() {
        return eb;
    }

    private Vector edgeVector = new Vector();

    public void addEdge(Edge e) {

        if (containsEdge(e))
            return;
        System.out.println("adding edge:" + e);
        edgeVector.addElement(e);
    }

    public boolean containsEdge(Edge e) {
        if (e == null) return true;
        for (int i = 0; i < edgeVector.size(); i++) {
            Edge e1 = (Edge) edgeVector.elementAt(i);
            if (e1.equals(e)) return true;
        }
        return false;
    }

    public int getNumberOfEdges() {
        return edgeVector.size();
    }

    public void addEdge(String nodeName1, String nodeName2) {
        addEdge(nodeName1, nodeName2, 40);
    }

    void addEdge(String from, String to, int len) {
        Edge e = new Edge();
        e.setFrom(nodes.findNode(from));
        e.setTo(nodes.findNode(to));
        e.setLen(len);
        addEdge(e);
    }

    public Edge getEdge(int i) {
        return (Edge) edgeVector.elementAt(i);
    }
}