//Paul S. Underwood
//SW409
//February 9, 2005

package futils.filters;

import java.io.File;
import java.io.FileFilter;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jan 8, 2005
 * <p/>
 * Time: 10:46:27 AM
 */
class DateFilter implements FileFilter {
    //discriminator supplied to constructor to determine how filtering will operate
    private int filter;
    private DateFilterBean dateFilterBean;

    //Permissible values for filter; defined here rather than in BitMasks because
    //they only concern acceptance criteria, which is a filtering function more than
    //a simple bit mask.
    private static final int ACCEPT_EVERYTHING = BitMasks.FILE_BIT | BitMasks.DIRECTORY_BIT;
    private static final int ACCEPT_ALL_FILES = BitMasks.FILE_BIT;
    private static final int ACCEPT_ALL_DIRECTORIES = BitMasks.DIRECTORY_BIT;
    private static final int ACCEPT_FILES_AFTER_DATE = BitMasks.FILE_BIT | BitMasks.DATED_BIT;
    private static final int ACCEPT_DIRECTORIES_AFTER_DATE = BitMasks.DIRECTORY_BIT | BitMasks.DATED_BIT;
    private static final int ACCEPT_ALL_AFTER_DATE = BitMasks.FILE_BIT | BitMasks.DIRECTORY_BIT | BitMasks.DATED_BIT;

    //Constructor gets a dateFilterBean and an inputFilter
    public DateFilter(DateFilterBean dateFilterBean, int inputFilter){
        this.dateFilterBean = dateFilterBean;
        filter = inputFilter;
    }

    //Execute to determine whether input parameter f matches the filter value.
    //case labels should match statics defined above.
    public boolean accept(File f){
        String suffix = dateFilterBean.getSuffix();
        if (suffix!=null) {
            File absoluteFile = f.getAbsoluteFile();
            boolean b = absoluteFile.toString().endsWith(suffix);
            return b;
        }
        switch(filter){
            case ACCEPT_EVERYTHING:
                return true;
            case ACCEPT_ALL_FILES:
                return f.isFile();
            case ACCEPT_ALL_DIRECTORIES:
                return f.isDirectory();
            case ACCEPT_FILES_AFTER_DATE:
                if(!f.isFile()) return false;
                return afterDate(f);
            case ACCEPT_DIRECTORIES_AFTER_DATE:
                if(!f.isDirectory()) return false;
                return afterDate(f);
            case ACCEPT_ALL_AFTER_DATE:
                return afterDate(f);
            default:
                System.out.println("DateFilter doesn't understand filter " + filter);
        }
        return false;
    }

    private boolean afterDate(File f) {
        if (f.lastModified() > dateFilterBean.getDate().getTime())
            return true;
        return false;
    }

}
