package futils;

import gui.In;
import gui.dialogs.DirectoryChooser;

import javax.swing.*;
import java.awt.*;
import java.io.*;
import java.util.Date;
import java.util.prefs.Preferences;

/**
 * The Futil class contains a number of methods for manipulating files.
 *
 * @author Douglas Lyon
 * @version 2.0
 */
public final class Futil {
    /**
     * Don't let anyone instantiate this class.
     */
    private Futil() {
    }

    private static boolean isSwing = true;
    private static File lastSelectedFile = null;

    public static void main(String[] args) {
        testFilePermission();
    }


    public static void showFileInfo() {
        File f = getReadFile("select a file");
        Date d = new Date(f.lastModified());
        System.out.println("file last modified after:" + d);
    }

    public static void binaryCopyFile() {
        byte b[] = readBytes(getReadFile("select a file"));
        writeBytes(getWriteFile("select a file to copy to"),
                b);
        System.out.println("copy done!");
    }

    /**
     * copy the file input stream into the file output stream.
     */
    public static void binaryCopyFile(FileInputStream fis,
                                      FileOutputStream fos)
            throws IOException {
        byte buffer[] = new byte[512];
        int count;
        while ((count = fis.read(buffer)) > 0)
            fos.write(buffer, 0, count);


    }

    public static void print(byte b[]) {
        for (int i = 0; i < b.length; i++) {
            if ((i % 10) == 0)
                System.out.println();
            System.out.print(b[i] + " ");
        }
    }

    /**
     * Futil.writeBytes inputs a File, f and byte array.
     * <p/>
     * Any failures cause readBytes to return false and a message is
     * printed to the console. Otherwise, writeBytes returns true.
     */
    public static boolean writeBytes(File f,
                                     byte b[]) {
        if (b==null) return false;
        System.out.println("got b in writebytes. B.length="+b.length);
        FileOutputStream fos = null;
        try {

            fos = new FileOutputStream(f);
            fos.write(b);
            fos.close();
            return true;
        } catch (IOException e) {
            System.out.println("Futil.writeBytes,Could not open " +
                    f+" "+e.getMessage());
            return false;
        }
    }

    /**
     * Futil.readBytes inputs a File, f and returns an array of bytes read
     * from the file. Any failures cause readBytes to return null. A
     * message is printed to the console.
     */
    public static byte[] readBytes(File f) {
        FileInputStream fis = null;
        int sizeInBytes = -1;
        byte buffer[] = null;
        try {
            fis = new FileInputStream(f);
            sizeInBytes = fis.available();
            buffer = new byte[sizeInBytes];
            fis.read(buffer);
            fis.close();
        } catch (IOException e) {
            System.out.println("Futil:readBytes, Could not open file");
        }
        return buffer;
    }
    /**
     * Recusive deletion of a file or path.
     * Danger will Robinson, Take cover Dr. Smith!
     * @param path to delete.
     * @return
     */
    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; i++) {
                if (files[i].isDirectory()) {
                    deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
            }
        }
        return (path.delete());
    }

    /**
     * copy and input file to an output file.
     */
    public static void copyFile(BufferedReader br,
                                BufferedWriter bw)
            throws IOException {
        String line = null;
        while ((line =
                br.readLine()) != null)
            bw.write(line + "\n");
        br.close();
        bw.close();
    }


    public static FileOutputStream getFileOutputStream(String prompt) {
        return getFileOutputStream(getWriteFile(prompt));
    }

    public static FileOutputStream getFileOutputStream(File f) {
        try {
            return new FileOutputStream(f);
        } catch (Exception e) {
            System.out.println("Er: FileOutputStream in Futil.java");
        }
        return null;
    }

    public static FileInputStream getFileInputStream(String prompt) {
        try {
            final File rf = Futil.getReadFile(prompt);
            if (rf == null) return null;
            if (!rf.exists()) {
                In.message("file does not exist:" + rf);
            }
            if (!rf.canRead()) {
                In.message("cannot read file:" + rf);
            }
            return new FileInputStream(rf);
        } catch (Exception e) {
            System.out.println("Er: FileOutputStream in Futil.java");
        }
        return null;
    }

    /**
     * check the state of the <code>isSwing</code> property. If false, AWT
     * will be used, instead (mostly).
     *
     * @return
     */
    public static boolean isSwing() {
        return isSwing;
    }

    /**
     * Use to set if swing is used for open dialog boxes.
     *
     * @param b
     */
    public static void setSwing(boolean b) {
        isSwing = b;
    }


    /**
     * Some versions of windows will create a .* suffix on a file name The
     * following code will strip it:
     */

    public static String FilterFileNameBug(String fname) {
        if (fname.endsWith(".*.*")) {
            fname =
                    fname.substring(0,
                            fname.length() - 4);
        }
        return fname;
    }

     public static void permission(File f){
         f.mkdir();
         WriterUtil.writeString("foo");

     }
    public static void testFilePermission(){
        File f = getWriteFile("select a file to write");
        permission(f);
    }
    /**
     * @param file Open the <code>file</code>
     * @return <code>-1</code> if file cannot be opened. Otherwise return
     *         the size, in bytes.
     */
    public static int available(File file) {
        FileInputStream fis = null;
        int sizeInBytes = -1;
        if (file.isDirectory()) return -1;
        try {
            fis = new FileInputStream(file);
            sizeInBytes = fis.available();
            fis.close();
        } catch (IOException e) {
            System.out.println("Futil:Could not open file");
        }
        return sizeInBytes;
    }

    public static void close(OutputStream os) {
        try {
            os.close();
        } catch (IOException exe) {
            System.out.println("futil: could not close output stream");
        }
    }


    /**
     * Inputs a path to a file, lists all the files in the directory and
     * renames them so that they are lower case.
     *
     * @param thePath the path to file used for processing.
     */
    public static void lowerFileNames(File thePath) {
        String[] fileNames = thePath.list();
        String pathstr = thePath.getPath();
        for (int i = 0;
             fileNames != null &&
                i < fileNames.length; i++) {
            String aFileName = fileNames[i];
            String newFileName = aFileName.toLowerCase();
            File theFile = new File(pathstr,
                    aFileName);
            if (theFile.isFile()) {
                //rename theFile to lower case
                System.out.print(i + ":" + aFileName);
                theFile.renameTo(new File(pathstr,
                        newFileName));
                System.out.println("\t==>\t" + newFileName);
            } else {
                //case theFile is Dir, in the Dir, repeat same procedure
                System.out.println("Dir:" + aFileName);
                lowerFileNames(new File(pathstr +
                        aFileName));
            }
        }
        return;
    }//lowerFileNames

    /**
     * inputs all the files in a directory and outputs a series of HREFS in
     * gui.html as a table of contents.
     */
    public static void makeTocHtml() {
        File[] files = WriterUtil.getFiles("select an .html file");
        System.out.println(files.length +
                " file(s):");
        FileWriter fw = WriterUtil.getFileWriter(
                "Where do you want me to save your TOC.html?");
        PrintWriter pw = new PrintWriter(fw);
        writeTocInHtml(pw, files);
        WriterUtil.close(fw);
    }

    public static void testGetReadFile() {
        System.out.println("you selected:"
                +
                getReadFile("select a file..."));
    }

    /**
     * Return a directory selected by the user. Remember the last place you
     * were by storing in in the <code>Preferences.userRoot</code>
     *
     * @param title titles dialog box
     * @return User selected <code>File</code> or <code>null</code>.
     */
    public static File getReadFileDir(String title) {
        final File readFile =
                Futil.getReadDirs(title)[0];
        if (readFile == null) return null;
        return readFile;
    }

    /**
     * Return a file instance. Remember the last place you were by storing
     * in in the <code>Preferences.userRoot</code>
     *
     * @param prompt
     * @return
     */
    public static File getReadFile(String prompt) {
        if (isSwing()) return getReadSwingFile(prompt);
        return getReadFileAWT(prompt);
    }

    private static final String key = "lastDirectoryVisitedForRead";

    private static File getReadSwingFile(String prompt) {
        Preferences p = Preferences.userRoot();

        String directory = p.get(key, null);
        if (directory != null) {
            final File currentDirectory = new File(directory);
            JFileChooser jfc = new JFileChooser(currentDirectory);
            return jGetFileHelper(jfc, prompt, p, key);
        }
        JFileChooser jfc1 = new JFileChooser(lastSelectedFile);
        return jGetFileHelper(jfc1, prompt, p, key);
    }

    private static File jGetFileHelper(JFileChooser jfc1,
                                       String prompt,
                                       Preferences p,
                                       final String key) {
        jfc1.setToolTipText(prompt);
        jfc1.setDialogTitle(prompt);
        jfc1.showOpenDialog(new JFrame(prompt));
        final File f = jfc1.getSelectedFile();
        if (f == null) return null;
        p.put(key, f.getParent());
        return f;
    }

    // File f = getReadFile("select a file");
    public static File getReadFileAWT(String prompt) {
        FileDialog fd = new FileDialog(new Frame(prompt),
                prompt);
        fd.setVisible(true);
        return new File(fd.getDirectory() + fd.getFile());
    }

    public static File JGetReadFile(String prompt) {
        JFileChooser jfc = new JFileChooser(lastSelectedFile);
        jfc.setToolTipText(prompt);
        jfc.setDialogTitle(prompt);
        jfc.showOpenDialog(new JFrame(prompt));
        return jfc.getSelectedFile();
    }

    public static void testGetReadDirs() {
        File f[] = getReadDirs();
        if (f == null) System.exit(0);
        for (int i = 0; i < f.length; i++)
            System.out.println(f[i]);
    }

    public static void testGetReadFiles() {
        File f[] = getReadFiles("select read files");
        if (f == null) System.exit(0);
        for (int i = 0; i < f.length; i++)
            System.out.println(f[i]);
        testGetReadFiles();
    }

    public static javax.swing.filechooser.FileFilter getFileFilter(
            String suffix) {
        class MyFilter extends javax.swing.filechooser.FileFilter {
            String suffix = "";

            MyFilter(String s) {
                suffix = s;
            }

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.endsWith(suffix);
            }

            public String getDescription() {
                return "*" + suffix;
            }
        }
        return new MyFilter(suffix);
    }

    /**
     * Prompt the user to select directories.
     *
     * @return the list of directories selected by the user.
     */
    public static File[] getReadDirs() {
        return getReadDirs("Directory selector");
    }

    /**
     * Prompt the user to select directories.
     *
     * @param title the title of the directory dialog
     * @return
     */
    private static File[] getReadDirs(String title) {
        JFileChooser jfc = null;
        if (lastSelectedFile != null)
            jfc = new JFileChooser(lastSelectedFile);
        else
            jfc = new JFileChooser();
        jfc.setDialogTitle(title);
        jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        jfc.setMultiSelectionEnabled(true);
        // Show the dialog; wait until dialog is closed
        int result = jfc.showOpenDialog(null);
        if (result == JFileChooser.APPROVE_OPTION) {
            lastSelectedFile =
                    jfc.getSelectedFiles()[0].getAbsoluteFile();
            return jfc.getSelectedFiles();
        }
        return null;
    }

    /**
     * Only allow the user to select read files.
     *
     * @param ff
     * @return
     */
    public static File[] getReadFiles(
            javax.swing.filechooser.FileFilter ff) {
        JFileChooser jfc = null;
        if (lastSelectedFile != null)
            jfc = new JFileChooser(lastSelectedFile);
        else
            jfc = new JFileChooser();
        jfc.setFileSelectionMode(JFileChooser.FILES_ONLY);
        jfc.setMultiSelectionEnabled(true);
        jfc.addChoosableFileFilter(ff);
        // Show the dialog; wait until dialog is closed
        int result = jfc.showOpenDialog(null);
        if (result == JFileChooser.APPROVE_OPTION) {
            lastSelectedFile =
                    jfc.getSelectedFiles()[0].getAbsoluteFile();
            return jfc.getSelectedFiles();
        }
        return null;
    }


    public static File[] getReadFiles(String prompt) {
        JFileChooser jfc = null;
        if (lastSelectedFile != null)
            jfc = new JFileChooser(lastSelectedFile);
        else
            jfc = new JFileChooser();
        jfc.setFileSelectionMode(JFileChooser.FILES_ONLY);
        jfc.setMultiSelectionEnabled(true);
        jfc.setToolTipText(prompt);
        jfc.setDialogTitle(prompt);
        // Show the dialog; wait until dialog is closed
        int result = jfc.showOpenDialog(null);
        if (result == JFileChooser.APPROVE_OPTION) {
            lastSelectedFile =
                    jfc.getSelectedFiles()[0].getAbsoluteFile();
            return jfc.getSelectedFiles();
        }
        return null;
    }

    public static File getReadDirFileJTree(String prompt) {
        String dir = DirectoryChooser.getDirectory(prompt);
        if (dir == null) return null;
        File f = new File(dir);
        return f;
    }


    private static void writeTocInHtml(PrintWriter pw,
                                       File files[]) {
        pw.println("<HTML>");
        pw.println("<BODY>");
        pw.println("<ul>");
        for (int i = 0; i < files.length; i++) {
            pw.println("<LI><a href = \"" +
                    files[i] +
                    "\">" +
                    files[i] +
                    "</a><P>");
            System.out.println(files[i]);
        }
        pw.println("</ul>");
        pw.println("</BODY>");
        pw.println("</HTML>");
    }


    void writeObject(ObjectOutputStream oos)
            throws IOException {
        oos.defaultWriteObject();
    }

    void readObject(ObjectInputStream ois)
            throws ClassNotFoundException,
                   IOException {
        ois.defaultReadObject();
    }

    public static void testCopyFile() {
        Examples.testCopyFile();

    }

    public static File getWriteFile(String prompt) {
        if (isSwing())
            return getWriteFileSwing(prompt);
        return getWriteFileAWT(prompt);
    }

    private static File getWriteFileAWT(String prompt) {
        FileDialog fd =
                new FileDialog(new Frame(),
                        prompt,
                        FileDialog.SAVE);
        fd.setVisible(true);

        return new File(fd.getDirectory()
                + fd.getFile());
    }

    public static File getWriteFileSwing(String prompt) {
        Preferences p = Preferences.userRoot();
        String directory = p.get(key, null);
        JFileChooser fd =
                new JFileChooser(prompt);
        if (directory != null)
            fd.setCurrentDirectory(new File(directory));
        fd.showSaveDialog(new JFrame());

        return
                fd.getSelectedFile();
    }


    public static void readDataFile(String fn,
                                    double data[]) {
        System.out.println("processing:\t" + fn);
        FileInputStream is =
                getFileInputStream(fn);
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        StreamTokenizer tokens = new StreamTokenizer(br);
        int next = 0;
        int num = 0;
        try {
            while ((next = tokens.nextToken()) !=
                    StreamTokenizer.TT_EOF) {
                switch (next) {
                    case StreamTokenizer.TT_WORD:
                        break;
                    case StreamTokenizer.TT_NUMBER:
                        data[num] = tokens.nval;
                        System.out.println(num +
                                ": " +
                                data[num]);
                        num = num + 1;
                        break;
                    case StreamTokenizer.TT_EOL:
                        break;
                }
            }

        } catch (Exception exe) {
            System.out.println("listFilteredHrefFile:er!");
        }
        close(is);
    }

    public static FileInputStream getFileInputStream(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        } catch (IOException e) {
            System.out.println("futil:Could not open file");
        }
        return fis;
    }

    public static FileReader getFileReader(String prompt) {
        FileReader fr = null;
        try {
            fr =
                    new FileReader(getReadFile(prompt));
        } catch (IOException e) {
            System.out.println("futil:Could not get file");
        }
        return fr;
    }

    public static FileWriter getFileWriter() {
        FileWriter fw = null;
        try {
            fw =
                    new FileWriter(getWriteFile("select out file"));
        } catch (IOException e) {
            System.out.println("futil:Could not create file");
        }
        return fw;
    }

    public static void close(InputStream is) {
        try {
            is.close();
        } // end try
        catch (IOException exe) {
            System.out.println("futil: could not close input stream");
        }
    }

    public static void writeFilteredHrefFile(File inputFile,
                                             String outputName) {
        System.out.println("Filtering:\t" +
                inputFile +
                "\t>\t" +
                outputName);
        try {
            FileInputStream is = new FileInputStream(inputFile);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            StreamTokenizer tokens = new StreamTokenizer(br);
            FileWriter os = new FileWriter(outputName);
            PrintWriter output = new PrintWriter(os);
            int i;
            int next = 0;
            tokens.resetSyntax();
            tokens.wordChars(0, 255);
            tokens.quoteChar('"');
            while ((next = tokens.nextToken()) !=
                    StreamTokenizer.TT_EOF) {
                switch (next) {
                    case '"':
                        output.print('"');
                        for (i = 0; i <
                                tokens.sval.length(); i++)
                            if (tokens.sval.charAt(i) ==
                                    ' ')
                                output.print("%20");
                            else
                                output.print(tokens.sval.charAt(i));
                        output.print('"');
                        break;
                    case StreamTokenizer.TT_WORD:
                        output.print(tokens.sval +
                                " ");
                        break;
                    case StreamTokenizer.TT_NUMBER:
                        output.print(tokens.nval +
                                " ");
                        break;
                    case StreamTokenizer.TT_EOL:
                        output.println();
                        break;
                } // end switch
            } // end while
            is.close();
            os.close();
        } // end try
        catch (Exception exe) {
            System.out.println("writeFilteredHrefFile:er!");
        }
    }

    public static String getReadFileName(String prompt) {
        final File readFile = getReadFile(prompt);
        if (readFile == null) return null;
        return readFile.toString();
    }

    public static String getReadFileName() {
        return
                getReadFileName("select a file");
    }

    public static boolean fileExists(String s) {
        File f = new File(s);
        return f.exists();
    }

    public static byte[] getBytes(File f) {
        byte b[] = null;
        try {
            FileInputStream fis = new FileInputStream(f);
            b = new byte[fis.available()];
            fis.read(b);
            fis.close();
        } catch (IOException e) {
            System.out.println("futil:Could not open file");
        }
        return b;
    }

    public static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(
                    UIManager.getCrossPlatformLookAndFeelClassName());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    public static void testGetDirFile() {
        System.out.println(
                getReadDirFileJTree("please select a directory").toString());
    }
}
