package futils;

import java.io.IOException;

public class Exec {
    Runtime rt = Runtime.getRuntime();

    public static void main(String args[]) {
        Exec e =
                new Exec();
        e.printRam();
    }

    public void setMethodTrace(boolean t) {
        rt.traceMethodCalls(t);
    }

    public void setInstructionTrace(boolean t) {
        rt.traceInstructions(t);
    }

    public void run(String s) {
        try {
            rt.exec(s);
        } catch (IOException e) {
            System.err.println("Exec error:" + e);
        }
    }

    public String getPrintRamString() {
        return "free " + getFreeRam()
                + " bytes out of "
                + getTotalRam() + " bytes\n" +
                getFreeRatioPercent() + " percent free";
    }

    public void printRam() {
        System.out.println(getPrintRamString());
    }

    public long getFreeRam() {
        return rt.freeMemory();
    }

    public long getTotalRam() {
        return rt.totalMemory();
    }

    public int getFreeRatioPercent() {
        return (int) (100 * getFreeRam() / (float) getTotalRam());
    }
}
