/*
 * CollectionsTest.java
 *
 * Created on December 4, 2002
 */

package collections.sortable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

/**
 * Demonstrates some of the functionality available
 * in the Collections class.
 *
 * @author  Thomas Rowland
 */
public class CollectionsTest {

    public static void main(String[] args) {
        List list = new ArrayList();
        list.add("C");
        list.add("A");
        list.add("D");
        list.add("B");

        System.out.println("\nInsertion order: ");
        displayList(list);

        System.out.println("\nNatural order: ");
        Collections.sort(list);
        displayList(list);

        System.out.println("Reverse natural order: ");
        Collections.sort(list, Collections.reverseOrder());
        displayList(list);

        System.out.println("Replace all B's with an X: ");
        // uncomment the following for jdk1.4.x
        //Collections.replaceAll(list, "B", "X");
        displayList(list);

    }

    private static void displayList(List lst) {
        ListIterator iter = lst.listIterator();
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
    }

}
