/*
 * Parent.java
 *
 * Created on December 3, 2002
 */

package collections.getclass;

/**
 * Base class using instanceof instead of getClass.
 * @author  Thomas Rowland
 */
public class Parent {

    private static int id = 1;

    public Parent() {
        System.out.println(toString());
    }

    /**
     * Overridden equals method using instanceof
     * instead of getClass causes problems when
     * comparing with derived classes.
     */
    public boolean equals(Object o) {
        //if (o.getClass() == this.getClass())
        if (o instanceof Parent)
            return (((Parent) o).getId() == this.id);
        return false;
    }

    public String toString() {
        return "I am a Parent";
    }

    public int getId() {
        return this.id;
    }

}
