package classUtils.resolver.util;

import classUtils.resolver.interfaces.Auditor;
import classUtils.resolver.interfaces.WalkObserver;
import classUtils.resolver.model.AuditableJarFile;

import java.io.File;
import java.util.jar.JarFile;

/**
 * @author Douglas Tillman, VTE Consulting, 12/2002
 * @version 2.0 http://home.attbi.com/~doug.tillman/index.html Provides
 *          callback functionality as the directory tree is walked in the
 *          JarGui class' walk() method.
 */
public class WalkObserverImpl implements WalkObserver {

    private Auditor auditor;

    public WalkObserverImpl(Auditor auditor) {

        this.auditor = auditor;

    }

    /**
     * @param root        - the current File object being examined
     * @param indentLevel - the level of indentation in the file system
     *                    directory tree.
     */
    public void at(File root, int indentLevel) {
        try {
            if (root.getName().endsWith(".jar")) {

                //Cast of File to JarFile to obtain additional functionality
                //of the JarFile class.
                JarFile jar  = new AuditableJarFile(root);


//begin building JarFile objects and updating AuditMaster Vector
                //jar.setExplodedContents();
                auditor.addJarFileToAudit(jar);

            }

        } catch (Exception e) {
            System.out.println("could not open:"+root);
           // e.printStackTrace(System.out);
        }
    }

}
