package classUtils.putils;

import utils.StringUtils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FileClassLoader extends URLClassLoader {
    private URL urls[];


    public static void main(String args[]) {

        ClassPathBean cpb = ClassPathBean.restore();
        URL urls[] = cpb.getClassPathUrls();
        FileClassLoader cucl =
                new FileClassLoader(urls);
        cucl.printPackages();
        cucl.printClasses();
        System.out.println("==== done ===");

    }

    public JarFile[] getJarFiles()
            throws IOException, URISyntaxException {
        JarFile jf[] = new JarFile[urls.length];
        for (int i = 0; i < urls.length; i++)
            jf[i] = new JarFile(new File(new URI(urls[i].toString())));
        return jf;
    }

    public Class[] getClasses()
            throws IOException, URISyntaxException {
        String s[] = getClassNames();
        Vector v = new Vector();
        for (int i = 0; i < s.length; i++)
            try {

                // try standard class loader first
                Class c = Class.forName(s[i]);
                v.addElement(c);
            } catch (Exception e1) {
                try {
                    // try CustomURLClassLoader Second.
                    Class c = Class.forName(s[i], false, this);
                    v.addElement(c);
                } catch (Exception e2) {

                }
            }
        Class ca[] = new Class[v.size()];
        v.copyInto(ca);
        return ca;
    }

    public void printClasses() {
        System.out.println("=== Class List ===");
        try {
            print(getClasses());

        } catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("---- end of class list ---");
    }

    public void print(Object o[]) {
        for (int i = 0; i < o.length; i++)
            System.out.println(o[i]);
    }

    public String[] getClassNames() throws IOException,
                                           URISyntaxException {
        JarEntry je[] = getClassEntries();
        Vector v = new Vector();
        for (int i = 0; i < je.length; i++)
            v.addElement(makeClassString(je[i].getName()));
        String s[] = new String[v.size()];
        v.copyInto(s);
        return s;
    }

    /**
     * takes a string of the java/lang/String.class form and returns
     * java.lang.String
     */
    public static String makeClassString(String s) {
        s = StringUtils.sub(s, ".class", "");
        s = s.replace('/', '.');
        s = s.replace('\\', '.');
        return s;
    }

    public JarEntry[] getClassEntries() throws IOException,
                                               URISyntaxException {
        JarFile jf[] = getJarFiles();
        Vector v = new Vector();
        for (int i = 0; i < jf.length; i++) {
            JarFile jf1 = jf[i];
            Vector v1 = new Vector();
            for (Enumeration e = jf1.entries(); e.hasMoreElements();) {
                Object o = e.nextElement();
                JarEntry je1 = (JarEntry) o;
                String s = je1.getName();

                if (s.endsWith(".class") && (-1 == s.indexOf('$')))
                    v1.addElement(je1);
            }
            JarEntry je1[] = new JarEntry[v1.size()];
            v1.copyInto(je1);
            JarEntry je[] = je1;
            for (int j = 0; j < je.length; j++)
                v.addElement(je[j]);
        }
        JarEntry je[] = new JarEntry[v.size()];
        v.copyInto(je);
        return je;
    }

    public void printPackages() {
        System.out.println("==== Package List ===");
        Package p[] = getPackages();
        for (int i = 0; i < p.length; i++)
            System.out.println(p[i]);
    }

    public FileClassLoader(URL urls[]) {
        super(urls);
        this.urls = urls;
    }

    public final synchronized Class loadClass(String name,
                                              boolean resolve)
            throws ClassNotFoundException {
        // First check if we have permission to access the package.
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            int i = name.lastIndexOf('.');
            if (i != -1) {
                sm.checkPackageAccess(name.substring(0, i));
            }
        }
        return super.loadClass(name, resolve);

    }

    protected Class findClass(final String name)
            throws ClassNotFoundException {
        // First check if we have permission to access the package.
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            int i = name.lastIndexOf('.');
            if (i != -1) {
                sm.checkPackageDefinition(name.substring(0, i));
            }
        }
        return super.findClass(name);
    }

    protected PermissionCollection getPermissions(CodeSource codesource) {
        // Use all the standard permissions, plus allow the code to
        // exit the VM.
        PermissionCollection pc = super.getPermissions(codesource);
        pc.add(new RuntimePermission("exitVM"));
        return pc;
    }
}
