package classUtils.putils;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.prefs.Preferences;


/**
 * Copyright DocJava, inc. User: lyon Date: Sep 6, 2004 Time: 10:25:51 AM
 */
public class ClassPathBean implements Serializable {
    private Vector classPathVector = new Vector();
    private String pathSeparator = System.getProperty("path.separator");

    private static final String key = "ClassPathBean";

    public ClassPathBean() {
        String classPaths[] = ClassPathUtils.getClassPaths();
        for (int i = 0; i < classPaths.length; i++)
            classPathVector.addElement(classPaths[i]);
    }

    public static void main(String[] args) {
        ClassPathBean cpb = ClassPathBean.restore();
        System.out.println(cpb.getClassPath());
    }

    public String getClassPath() {
        return toString();
    }

    public Enumeration getPathEnumeration() {
        return classPathVector.elements();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        final String[] classPaths = getClassPaths();
        for (int i = 0;
             i < classPaths.length;
             i++) {
            sb.append(classPaths[i]);
            sb.append(pathSeparator);
        }
        return sb.toString();
    }

    public String[] getClassPaths() {
        String s[] = new String[classPathVector.size()];
        classPathVector.copyInto(s);
        return s;
    }

    /**
     * append a path (with no delimeters) to the internall held vector. Can
     * be a dir or a jar.
     *
     * @param path
     */
    public void addClassPath(String path) {
        classPathVector.addElement(path);
    }

    /**
     * Overwrite the internally held vector.
     *
     * @param classPaths
     */
    public void setClassPaths(String classPaths[]) {
        classPathVector = new Vector();
        for (int i = 0; i < classPaths.length; i++)
            classPathVector.addElement(classPaths[i]);
    }

    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save() {
        try {
            Preferences p = Preferences.userRoot();
            ByteArrayOutputStream baos = new
                    ByteArrayOutputStream();
            ObjectOutputStream oos = new
                    ObjectOutputStream(baos);
            oos.writeObject(this);
            baos.close();
            p.putByteArray(key, baos.toByteArray());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * restores the properties from the preference in the user root.
     */
    public static ClassPathBean restore() {
        try {
            Preferences p = Preferences.userRoot();
            byte b [] = p.getByteArray(key, null);
            if (b == null)
                return new ClassPathBean();
            ByteArrayInputStream bais = new
                    ByteArrayInputStream(b);
            ObjectInputStream ois = new
                    ObjectInputStream(bais);
            Object o = ois.readObject();
            bais.close();
            return (ClassPathBean) o;
        } catch (IOException e) {
        } catch (ClassNotFoundException e) {
        }
        return new ClassPathBean();
    }

    /**
     * Get all the readable files with a .jar suffix
     *
     * @return
     */
    public File[] getJars() {
        Vector v = new Vector();
        for (int i = 0; i < classPathVector.size(); i++) {
            String s = (String) classPathVector.elementAt(i);
            File f = new File(s);

            if (s.endsWith(".jar") && (f.canRead()))
                v.addElement(f);
        }
        File fa[] = new File[v.size()];
        v.copyInto(fa);
        return fa;
    }

    /**
     * Get all the dirs
     *
     * @return
     */
    public File[] getDirs() {
        Vector v = new Vector();
        for (int i = 0; i < classPathVector.size(); i++) {
            String s = (String) classPathVector.elementAt(i);
            File f = new File(s);


            if (f.isDirectory())
                v.addElement(f);
        }
        File fa[] = new File[v.size()];
        v.copyInto(fa);
        return fa;
    }

    /**
     * Get all the readable files with a .zip suffix
     *
     * @return
     */
    public File[] getJarsAndZips() {
        Vector v = new Vector();
        for (int i = 0; i < classPathVector.size(); i++) {
            String s = (String) classPathVector.elementAt(i);
            File f = new File(s);

            final boolean isZip = s.endsWith(".zip");
            final boolean isJar = s.endsWith(".jar");
            if ((isZip || isJar) && f.canRead())
                v.addElement(f);
        }
        File fa[] = new File[v.size()];
        v.copyInto(fa);
        return fa;
    }

    /**
     * Get all the readable files with a .zip suffix
     *
     * @return
     */
    public File[] getZips() {
        Vector v = new Vector();
        for (int i = 0; i < classPathVector.size(); i++) {
            String s = (String) classPathVector.elementAt(i);
            File f = new File(s);

            if (s.endsWith(".zip") && (f.canRead()))
                v.addElement(f);
        }
        File fa[] = new File[v.size()];
        v.copyInto(fa);
        return fa;
    }

    /**
     * Erase internally held class path and erase it with the long path
     * delimited string.
     *
     * @param classPath
     */
    public void setClassPath(java.lang.String classPath) {
        classPathVector = new Vector();
        StringTokenizer st =
                new StringTokenizer(classPath,
                        pathSeparator);
        int n = st.countTokens();
        for (int i = 0; i < n; i++)
            classPathVector.addElement(st.nextToken());
    }

    public URL[] getClassPathUrls() {
        String s[] = this.getClassPaths();
        Vector v = new Vector();
        for (int i = 0; i < s.length; i++)
            try {
                v.addElement(new URL(s[i]));
            } catch (MalformedURLException e) {

            }
        URL u[] = new URL[v.size()];
        v.copyInto(u);
        return u;
    }

    public void printJars() {
        File f[] = getJars();
        for (int i=0;i < f.length; i++)
            System.out.println("jar:"+f[i].getAbsolutePath());
    }
}
