/* Generated by Together */

package classUtils.pack.util;

import java.io.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/**
 * A PrintWriter which indents each line of text with a given character.
 *
 * @author Cris Sadun
 * @version 1.2
 */
public class IndentedPrintWriter extends PrintWriter {

   private static char [] ls=System.getProperty("line.separator").toCharArray();
   private int truncatedNL;
   private char []spc;
   private boolean start=true;
   private char indentationChar;
   private boolean autoFlush;

   /**
    * Create a new writer over the given one, with the given indentation value.
    * The indentation charachter defaults to blank - use {@link
    * IndentedPrintWriter#setIndentationChar(char) setIndentationChar()} to set it differently
    * if required.
    * @param w the writer wrapped by this IndentationPrintWriter
    * @param indent the indentation level
    */
   public IndentedPrintWriter(Writer w, int indent) {
    this(w, indent, false);
   }

   /**
    * Create a new writer over the given stream, with the given indentation value.
    * The indentation charachter defaults to blank - use {@link
    * IndentedPrintWriter#setIndentationChar(char) setIndentationChar()} to set it differently
    * if required.
    * @param out the stream wrapped by this IndentationPrintWriter
    * @param indent the indentation level
    * @param autoFlush if true, the println() methods will flush the output buffer
    */
   public IndentedPrintWriter(OutputStream out, int indent, boolean autoFlush) {
        this(new BufferedWriter(new OutputStreamWriter(out)), indent, autoFlush);
   }

   /**
    * Create a new writer over the given stream, with the given indentation value,
    * and no autoflush.
    * The indentation charachter defaults to blank - use {@link
    * IndentedPrintWriter#setIndentationChar(char) setIndentationChar()} to set it differently
    * if required.
    * @param out the stream wrapped by this IndentationPrintWriter
    * @param indent the indentation level
    */
   public IndentedPrintWriter(OutputStream out, int indent) {
       this(out, indent, false);
   }

   /**
    * Create a new writer over the given one, with the given indentation value.
    * The indentation charachter defaults to blank - use {@link
    * IndentedPrintWriter#setIndentationChar(char) setIndentationChar()} to set it differently
    * if required.
    * @param w the writer wrapped by this IndentationPrintWriter
    * @param indent the indentation level
    * @param autoFlush if true, the println() methods will flush the output buffer
    */
   public IndentedPrintWriter(Writer w, int indent, boolean autoFlush) {
       super(w, autoFlush);
       this.truncatedNL=0;
       this.indentationChar=' ';
       this.autoFlush=autoFlush;
       setIndentation(indent);
   }

   /**
    * Create a new writer over the given one, with the default indentation value,
    * and no autoflush.
    * The indentation charachter defaults to blank - use {@link
    * IndentedPrintWriter#setIndentationChar(char) setIndentationChar()} to set it differently
    * if required.
    * @param w the writer wrapped by this IndentationPrintWriter
    */
   public IndentedPrintWriter(Writer w) {
	this(w, 0);
   }

   /**
    * Create a new writer over the given stream, with the default indentation value.
    * The indentation charachter defaults to blank - use {@link
    * IndentedPrintWriter#setIndentationChar(char) setIndentationChar()} to set it differently
    * if required.
    * @param out the stream wrapped by this IndentationPrintWriter
    * @param autoFlush if true, the println() methods will flush the output buffer
    */
   public IndentedPrintWriter(OutputStream out, boolean autoFlush) {
		this(out, 0, autoFlush);
   }


   /**
    * Create a new writer over the given stream, with the default indentation value
    * and no autoflush.
    * The indentation charachter defaults to blank - use {@link
    * IndentedPrintWriter#setIndentationChar(char) setIndentationChar()} to set it differently
    * if required.
    * @param out the stream wrapped by this IndentationPrintWriter
    */
   public IndentedPrintWriter(OutputStream out) {
	   this(out, 0);
   }

   /**
    * Create a new writer over the given one, with the defaukt indentation value.
    * The indentation charachter defaults to blank - use {@link
    * IndentedPrintWriter#setIndentationChar(char) setIndentationChar()} to set it differently
    * if required.
    * @param w the writer wrapped by this IndentationPrintWriter
    * @param autoFlush if true, the println() methods will flush the output buffer
    */
   public IndentedPrintWriter(Writer w, boolean autoFlush) {
        this(w, 0, autoFlush);
   }

   /**
    * Return the current indentation level
    * @return the current indentation level
    */
   public int getIndentation(){ return spc.length; }

   /**
    * Sets the current indentation level
    * @param indent the desired indentation level
    */
   public synchronized void setIndentation(int indent){
    if (indent < 0) throw new RuntimeException("Attmpting to set negative indentation");
    spc = new char[indent];
    Arrays.fill(spc, indentationChar);
   }

   /**
	* Increment the current indentation level of the given level.
	* @param level the indentation level to be incremented
    */
   public void incIndentation(int level) { setIndentation(getIndentation()+level); }

   /**
    * Decrement the current indentation level of the given level.
    * 0 is the minimum level.
    * @param level the indentation level to be reduced
    */
   public void decIndentation(int level) { setIndentation(getIndentation()-level); }

   /**
    * Increment the current indentation level.
    * <p>
    */
   public void incIndentation() { incIndentation(1); }

   /**
    * Decrement the current indentation level. 0 is the minimum level.
    * <p>
    */
   public void decIndentation() { decIndentation(1); }

   /**
    * Set the charachter used to indent to the given character
    * @param c the charachter to use for indentation
    */
   public synchronized void setIndentationChar(char c) {
    this.indentationChar=c;
    setIndentation(getIndentation());
   }

   /**
    * Return the charachter used to indent to the given character
    * @return the charachter to use for indentation
    */
   public char getIndentationChar() { return indentationChar; }

   /**
    * Write a substring of a string, of given length from a given offset
    */
   public void write(String s, int off, int len) {
	 write(s.toCharArray(), off, len);
   }

   /**
    * Write a character
    */
   public void write(int c) {
    write(new char[] { (char)c }, 0, 1);
   }

   /**
    * Write a portion of character array, of given length from a given offset
    */
   public void write(char buf[], int off, int len) {
    synchronized(out) {

     if (start) {
        super.write(spc, 0, spc.length);
        start=false;
     }

     List pos = new ArrayList();
     int truncated=truncatedNL; // Remember if we start in a truncated-newline situation
     for(int i=off;i<off+len;i++) {
 		if (isNL(buf, i, off+len)) pos.add(new Integer(i));
     }
	 int p1 = 0;
     String s;
     for(Iterator i=pos.iterator();i.hasNext(); ) {
       int p2 = ((Integer)i.next()).intValue();
	   super.write(buf, p1, p2-p1);
       super.write(ls, 0, ls.length);
       super.write(spc, 0, spc.length);
       p1=p2+ls.length-truncated;
	   if (truncated!=0) truncated=0; // Just the first time
   	 }
  	 super.write(buf, p1, off+len-p1);
	 if (autoFlush) super.flush();
    }
   }

   /**
    * Checks if buf matches the line separator this.ls,
    * setting this.truncatedNL if a partial match exists
    * but the buffer portion is too short for a complete
    * match
    */
   private boolean isNL(char []buf, int start, int end) {
   for(int i=truncatedNL;i<ls.length && start+i<end;i++) {
   		int pos = start+i-truncatedNL;
        if (buf[pos]!=ls[i]) {
            if (truncatedNL !=0) truncatedNL=0;
            return false;
        }
    }
    if (end-start+truncatedNL < ls.length) {
        truncatedNL=end-start;
        return false;
    }
	if (truncatedNL !=0) truncatedNL=0;
    return true;
   }


   /**
    * Terminate the current line by writing the line separator string.  The
    * line separator string is defined by the system property
    * <code>line.separator</code>, and is not necessarily a single newline
    * character (<code>'\n'</code>).
    */
   public void println() {
	super.println();
	flush();
	start=true;
   }

   /*public static void main(String []args) throws Exception {
     IndentedPrintWriter pw = new IndentedPrintWriter(System.out, 5);
     //pw.autoFlush=true;
     pw.write(ls[0]);
     pw.write(ls[1]);
     
	 pw.print("This is a test... \r");
 	 pw.print("\nlet'see.");
     pw.println("Hello"+System.getProperty("line.separator")+"World");
   }*/

}

