package bookExamples.ch34BeanProperties;

import gui.ClosableJFrame;

import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;

/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Feb 23, 2005
 * Time: 1:25:26 PM
 * Copyright DocJava, 2005
 */
public class PropertyManagerUtil extends PropertyEditorManager {

    public static void main(String args[]) {
        PropertyManagerUtil.registerEditor(Integer.class, IntegerEditor.class);
        PropertyEditor pe = PropertyManagerUtil.findEditor(Integer.class);
        if (pe == null) return;
        System.out.println("custom editor=" + pe.supportsCustomEditor());
        IntegerEditor ie = new IntegerEditor();
        ie.setPrompt("enter a number between 0 and 10",0,10);
        Component comp = pe.getCustomEditor();
        final ClosableJFrame cf = new ClosableJFrame();
        pe.addPropertyChangeListener(new PropertyChangeListener() {

            public void propertyChange(PropertyChangeEvent evt) {
                cf.repaint();
            }
        });
        Container c = cf.getContentPane();
        c.setLayout(new FlowLayout());
        c.add(comp);
        cf.setSize(200, 200);
        cf.setVisible(true);
    }
}
