package bookExamples.ch26Graphics.testPatterns;

import gui.ClosableJFrame;
import gui.run.RunMenu;
import gui.run.RunMenuItem;
import j2d.ImageUtils;

import javax.swing.*;
import java.awt.*;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Dec 27, 2004
 * <p/>
 * Time: 8:41:59 PM
 */
// ip.gui.TestPatternFrame
public class TestPatternFrame extends ClosableJFrame  {
    private SnellWlx snellWlcx = new SnellWlx();

    private JMenuBar mbar = new JMenuBar();


    public static void main(String args[]) {
        TestPatternFrame tpf = new TestPatternFrame();
        tpf.setSize(200, 200);

        tpf.setVisible(true);
    }

    public TestPatternFrame() {
        super("Test Patterns");
        mbar.add(getTestPatternsMenu());
        Container c = getContentPane();
        setJMenuBar(mbar);
        c.setLayout(new GridLayout(1, 0));
        c.add(snellWlcx);
    }


    public JMenu getTestPatternsMenu() {
        JMenu jm = new RunMenu("[test patterns");
        jm.add(new RunMenuItem("[eiabars{ctrl E}") {
            public void run() {
                snellWlcx.setOption(1);
            }
        });
        jm.add(new RunMenuItem("[chip_chart{ctrl C}") {
            public void run() {
                snellWlcx.setOption(2);
            }
        });
        jm.add(new RunMenuItem("[black{ctrl B}") {
            public void run() {
                snellWlcx.setOption(3);
            }
        });
        jm.add(new RunMenuItem("[white{ctrl W}") {
            public void run() {
                snellWlcx.setOption(4);
            }
        });
        jm.add(new RunMenuItem("[grid{ctrl G}") {
            public void run() {
                snellWlcx.setOption(5);
            }
        });
        jm.add(new RunMenuItem("p[ulse and bar{ctrl U}") {
            public void run() {
                snellWlcx.setOption(6);
            }
        });
        jm.add(new RunMenuItem("s[mpte bars{ctrl M}") {
            public void run() {
                snellWlcx.setOption(7);
            }
        });
        jm.add(new RunMenuItem("[increase grid{ctrl I}") {
            public void run() {
                snellWlcx.increaseStep();
            }
        });
        jm.add(new RunMenuItem("[decrease grid{ctrl D}") {
            public void run() {
                snellWlcx.decreaseStep();
            }
        });
        jm.add(new RunMenuItem("[snell & wilcox{ctrl W}") {
            public void run() {
                snellWlcx.setOption(8);
            }
        });
        jm.add(new RunMenuItem("[Full screen{ctrl F}") {
            public void run() {
                TestPatternFrame.this.setSize(ImageUtils.getScreenSize());
            }
        });
        jm.add(new RunMenuItem("[print...{ctrl P}") {
            public void run() {
                snellWlcx.print();
            }
        });
        jm.add(new RunMenuItem("[quit{ctrl Q}") {
            public void run() {
                System.exit(0);
            }
        });

        return jm;
    }

    public JPanel getDrawPanel() {
        return snellWlcx;
    }
}

