package bookExamples.ch26Graphics.draw2d;

import java.awt.*;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public class Rubberband extends MouseAdapter implements MouseMotionListener {
    private int startX, startY, lastX, lastY;
    private Rubberbandable target;

    public Rubberband(Rubberbandable target) {
        this.target = target;
    }

    public void mousePressed(MouseEvent evt) {
        startX = lastX = evt.getX();
        startY = lastY = evt.getY();
    }

    public void mouseReleased(MouseEvent evt) {
        Graphics g = target.getGraphics();
        g.setXORMode(Color.lightGray);

        drawRect(g, startX, startY, lastX, lastY);
        target.onRubberbandEnd(startX, startY, lastX, lastY);
    }

    public void mouseDragged(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();

        Graphics g = target.getGraphics();
        g.setXORMode(Color.lightGray);
        drawRect(g, startX, startY, lastX, lastY);
        drawRect(g, startX, startY, x, y);
        lastX = x;
        lastY = y;
    }

    public void mouseMoved(MouseEvent evt) {
    }

    private void drawRect(Graphics g, int startX, int startY, int endX, int endY) {
        int[] coords = Coords.translateCoords(startX, startY, endX, endY);
        g.drawRect(coords[0], coords[1], coords[2], coords[3]);
    }
}

