package bookExamples.ch26Graphics.draw2d;


import gui.In;
import gui.run.RunButton;
import gui.run.RunSlider;

import javax.swing.*;
import java.awt.*;
import java.beans.PropertyEditor;

public class Point2d extends DJShape implements PropertyEditor {
    public Point2d(int x1, int y1, int x2, int y2) {
        super(x1, y1, x2, y2);
    }

    public Point getCenter() {
        return new Point(x1, y1);
    }

    public DJShape getInstance(int x1, int y1, int x2, int y2) {
        return new Point2d(x1, y1, x2, y2);
    }

    public void draw(Graphics g) {
        g.drawLine(x1, y1, x1 + 1, y1 + 1);
    }

    public boolean isPaintable() {
        return false;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public Component getCustomEditor() {

        Point pc = getCenter();
        int xc = pc.x;
        int yc = pc.y;
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new JLabel("y1"));
        jp.add(new RunSlider(RunSlider.HORIZONTAL, 10, 2000, yc) {
            public void run() {
                y1 = getValue();
                pcs.firePropertyChange("size", Point2d.this, null);
            }
        });

        jp.add(new JLabel("x1"));
        jp.add(new RunSlider(RunSlider.HORIZONTAL, 10, 2000, xc) {
            public void run() {
                x1 = getValue();
                pcs.firePropertyChange("size", Point2d.this, null);
            }
        });

        jp.add(new RunButton("setForeground") {
            public void run() {
                Point2d.this.setForeground(In.getColor());
                //  pcs.firePropertyChange("Octagon",null,this);
                pcs.firePropertyChange("size", Point2d.this, null);
            }
        });

        jp.setLayout(new FlowLayout());

        return jp;

    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object value) {
    }

    public String getAsText() {
        return null;
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String[] getTags() {
        return new String[0];
    }

    public void setAsText(String text) throws IllegalArgumentException {
    }

    public void paintValue(Graphics gfx, Rectangle box) {
    }
}