package bookExamples.ch26Graphics.draw2d;

/**
 * Created by Randeep Singh
 * Professor: Dr. Douglas Lyon
 * Due Date: Feb 9, 2005
 * Class: CR 325
 */

import j2d.ImageUtils;

import java.awt.*;

public class ImageDJShape extends DJShape {
    int x1 = 0;
    int y1 = 0;
    int x2 = 0;
    int y2 = 0;
    private Image image = ImageUtils.getImage();

    public ImageDJShape(int x1, int y1, int x2, int y2) {
        super(x1, y1, x2, y2);
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        ImageUtils.waitForImage(image);
        setSize(image.getWidth(null), image.getHeight(null));
    }

    private void setSize(int width, int height) {
        setSize(new Dimension(width, height));
    }

    public void draw(Graphics g) {

        Graphics2D g2d = (Graphics2D) g;
        int w = Math.abs(x1 - x2);
        int h = Math.abs(y1 - y2);
        g2d.drawImage(image, x1, y1, w, h, null);
        // AffineTransform affineTransform = getAffineTransform();
        // double sw =  image.getWidth(this)/w;
        // double sh =  image.getHeight(this)/h;
        //  affineTransform.setToScale(sw,sh);
        // g2d.drawImage(image,
        //         affineTransform, null);

    }

    public Point getCenter() {
        Dimension d = getSize();
        return new Point(x1 + d.width / 2, y2 + d.height / 2);
    }

    Point pc = new Point(x1, y1);

    public DJShape getInstance(int x1, int y1, int x2, int y2) {
        ImageDJShape imageShape = new ImageDJShape(x1, y1, x2, y2);
        imageShape.setAffineTransform(getAffineTransform());
        return imageShape;
    }
}