/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package bookExamples.ch26Graphics;

import bookExamples.ch26Graphics.draw2d.CircleFcn;
import bookExamples.ch26Graphics.draw2d.SineCircleFcn;
import bookExamples.ch26Graphics.draw2d.SineFcn;

import javax.swing.*;
import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class PlotFrame extends JFrame
        implements PropertyChangeListener {
    Container c = getContentPane();
    //CircleFcn

    PlotPoint2D scf = new PlotPoint2D(new SineCircleFcn(200, 200, 10));


    PlotPoint2D ppc = new PlotPoint2D(new CircleFcn(200, 200, 20));
    SineFcn f = new SineFcn();
    PlotPoint2D pp2d = new PlotPoint2D(f);

    PlotFrame() {
        setSize(400, 400);
        setVisible(true);
        JDialog jd = new JDialog();
        Container c = jd.getContentPane();
        c.add(f.getCustomEditor());
        c.setLayout(new FlowLayout());
        jd.setSize(200,400);
        jd.setVisible(true);
        f.addPropertyChangeListener(this);

    }
    public void propertyChange(PropertyChangeEvent pce){
        Object o = pce.getNewValue();
        f = (SineFcn) o;
        repaint();
    }


    public static void main(String args[]) {
         new PlotFrame();

    }

    double eps = .04;


    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D) g;
        g2d.draw(ppc.getGeneralPath(eps));
        g2d.draw(pp2d.getGeneralPath(eps));
        g2d.draw(scf.getGeneralPath(eps));
        //eps = eps - 0.04;
    }
}
