package bookExamples.ch18Swing.awt;

import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;


public class BlinkFrame extends Frame implements
        MouseListener, Runnable {

    Thread thread;
    Color[] colors =
            {Color.red, Color.green, Color.blue};
    int index = 0;

    public void init() {

        thread = new Thread(this);
        thread.start();
        addMouseListener(this);
    }

    public void run() {
        repaint();
    }

    public static void main(String args[]) {
        BlinkFrame b = new BlinkFrame();
        b.setVisible(true);
        b.setSize(200, 200);
        b.init();
    }

    public void paint(Graphics g) {
        while (true) {
            try {
                g.setColor(colors[index]);
                g.fillOval(30, 30, 20, 20);
                thread.sleep(500);
                g.setColor(Color.white);
                g.fillOval(30, 30, 20, 20);
                thread.sleep(250);
            } catch (InterruptedException e) {
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        index = (index + 1) % colors.length;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

}