/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package bookExamples.ch18Swing;


import futils.Futil;
import futils.ReaderUtil;

import javax.swing.*;
import javax.swing.text.html.HTMLEditorKit;
import java.awt.*;

public class HtmlView
        extends JFrame {
    public HtmlView() {
        setTitle("Html Text Application");
        setSize(400, 240);
        setBackground(Color.gray);
        getContentPane().setLayout(new BorderLayout());

        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        getContentPane().add(topPanel, BorderLayout.CENTER);

        // Create an RTF editor window
        HTMLEditorKit html = new HTMLEditorKit();
        JEditorPane editor = new JEditorPane();
        editor.setBackground(Color.white);

        // This text could be big so add a scroll pane
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(editor);
        topPanel.add(scroller, BorderLayout.CENTER);


        String s = ReaderUtil.getFileAsOneBigString(
                Futil.getReadFile("select an Html file"));
        editor.setContentType("text/html");
        editor.setText(s);

    }
    //todo this needs more testing.
    public static void main(String args[]) {
        // Create an instance of the test application
        HtmlView mainFrame = new HtmlView();
        mainFrame.setVisible(true);
    }
}
