/*
 * bounce.java
 *
 * Created on December 12, 2002, 6:57 PM
 * @author  greg stewart
 * reproduction prohibited without authorisation
 */

package bookExamples.ch08ArraysAndVectors.array;

import javax.swing.*;

class IO {
    public static float getVal(Object o) {
        return Float.parseFloat(JOptionPane.showInputDialog(o));
    } /*end getVal()*/

    public static void sysout(Object o) {
        System.out.print(o);
    } /*end sysout()*/
} /*end IO{}*/

public class Bounce {
    int S1, pos = 0;
    float S2, L, V, C;
    float T[] = new float[20];

    /** Creates a new instance of Bounce */
    public Bounce(float _V, float _S2, float _C) {
        IO.sysout("\nV = " + (V = _V));
        IO.sysout("\nS2 = " + (S2 = _S2));
        IO.sysout("\nC = " + (C = _C));
        IO.sysout("\nS1=" + (S1 = (int) (70 / (V / (16 * S2)))) + "\n");
    } /*end constructor()*/

    /* OVER-modularised & time-consuming code: */
    public void fillTime() {
        for (int i = 1; i <= S1; i++) {
            T[i] = (float) (V * Math.pow(C, (i - 1)) / 16);
        } /*end for(i)*/
    } /*end fillTime()*/

    /* More OVER-modularised & time-consuming code: */
    public float getHeight() {
        return (int) (-16 * ((V / 32) * (V / 32)) + (V * V) / 32 + 0.5);
    } /*end getHeight()*/

    /* Still More OVER-modularised & time-consuming code: */
    public float getXCoor(int i, float j, float H) {
        return (float) Math.abs((H - (0.5 * (-32) * (j * j) + V * Math.pow(C, (i - 1)) * j)));
    } /*end getXCoor()*/

    public void plotHeight() {
        float t, height = getHeight();
        for (float H = height; H >= 0; H -= 0.5) {
            if (H == (int) H) {
                IO.sysout("" + (int) H);
            } /*end if(H)*/
            L = 0;
            for (int i = 1; i <= S1; i++) {
                plotVal(i, H);
                t = T[i + 1] / 2;
                if (((-16) * (t * t) + V * Math.pow(C, (i - 1)) * t) < H) {
                    pos = 0;
                    IO.sysout("\n");
                    break;
                } /*end if([math])*/
            } /*end for(i)*/
        } /*end for(h)*/
    } /*end plotHeight()*/

    public void plotVal(int i, float H) {
        for (float j = 0; j <= T[i]; j += S2) {
            L += S2;
            float temp = getXCoor(i, j, H);
            if (temp <= .25) {
//		debug("[" + (int)(L/S2) + ":" + pos + "]");
                IO.sysout(padString((int) (L / S2)) + "0");
            } /*end if(temp)*/
        } /*end for(j)*/
    } /*end plotVal()*/

    public void printAxis() {
        IO.sysout("\n");
        for (int i = 1; i <= (int) (L + 1) / S1 + 1; i++) {
            IO.sysout(". ");
        } /*end for(i)*/
    } /*end printAxis()*/

    public void labelAxis() {
        pos = 0;
        IO.sysout("\n0");
        for (int i = 1; i <= (int) (L + .9995); i++) {
//	    debug("[" + (int)(i/S2) + ":" + pos + "]");
            IO.sysout(padString((int) (i / S2)) + i);
        } /*end for(i)*/
        IO.sysout("\n" + padString((int) ((L + 1) / (2 * S2) - 2) + pos) + "Seconds");
    } /*end labelAxis()*/

    public String padString(int l) {
        String s = "";
        for (int i = 0; i <= (l - pos); i++) {
            s += " ";
        }
        pos += s.length();
        return s;
    }

    public void run() {
        IO.sysout("\n");
        this.fillTime();
        this.plotHeight();
        this.printAxis();
        this.labelAxis();
    } /*end run()*/

    /* remove all debug() when satisfied. */
    public void debug(Object o) {
        IO.sysout(o);
    } /*end debug()*/

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        Bounce b = new Bounce(IO.getVal("Velocity (FPS): "),
                IO.getVal("Time Increment (Sec): "),
                IO.getVal("Coefficient: "));
        b.run();
    } /*end main()*/

} /*end class Bounce{}*/