/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package addbk.print.labels;

import gui.run.RunButton;
import gui.run.RunComboBox;

import javax.swing.*;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

public class PrintPreview
        extends JFrame {
    protected int m_wPage;
    protected int m_hPage;
    protected int m_orientation;
    protected Printable target;
    protected JComboBox scale;
    protected PreviewPanel previewPanel = new PreviewPanel(this);

    public PrintPreview(Printable target) {
        this(target, "Print Preview", PageFormat.PORTRAIT);
    }

    public PrintPreview(
            Printable printableThing, String title, int orientation) {
        super(title);

        setSize(600, 400);
        getContentPane().setLayout(new BorderLayout());
        this.target = printableThing;
        m_orientation = orientation;

        JToolBar tb = new JToolBar();
        tb.add(
                new RunButton("Print") {
                    public void run() {
                        doPrintButton();
                    }
                });

        tb.add(
                new RunButton("Close") {
                    public void run() {
                        dispose();
                    }
                });

        scale = new RunComboBox(new String[]{"50 %", "100 %"}) {
            public void run() {
                Thread runner = new Thread() {
                    public void run() {
                        String str = scale.getSelectedItem().
                                toString();
                        if (str.endsWith("%"))
                            str = str.substring(0, str.length() - 1);
                        str = str.trim();
                        int scale = 0;
                        try {
                            scale = Integer.parseInt(str);
                        } catch (NumberFormatException ex) {
                            return;
                        }
                        int w = (int) (m_wPage * scale / 100);
                        int h = (int) (m_hPage * scale / 100);

                        Component[] comps = previewPanel.getComponents();
                        for (int k = 0; k < comps.length; k++) {
                            if (!(comps[k] instanceof PagePreview))
                                continue;
                            PagePreview pp = (PagePreview) comps[k];
                            pp.setScaledSize(w, h);
                        }
                        previewPanel.doLayout();
                        previewPanel.getParent().getParent().validate();
                    }
                };
                runner.start();

            }
        };

        scale.setMaximumSize(scale.getPreferredSize());
        scale.setEditable(true);
        tb.add(scale);
        getContentPane().add(tb, BorderLayout.NORTH);

        previewPanel = new PreviewPanel(this);

        PrinterJob prnJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = prnJob.defaultPage();
        pageFormat.setOrientation(m_orientation);

        if (pageFormat.getHeight() == 0 || pageFormat.getWidth() == 0) {
            System.err.println("Unable to determine default page size");
            return;
        }
        m_wPage = (int) (pageFormat.getWidth());
        m_hPage = (int) (pageFormat.getHeight());
        int scale = 50;
        int w = (int) (m_wPage * scale / 100);
        int h = (int) (m_hPage * scale / 100);

        int pageIndex = 0;
        try {
            while (true) {

                BufferedImage img = new BufferedImage(
                        m_wPage,
                        m_hPage, BufferedImage.TYPE_INT_RGB);
                Graphics g = img.getGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, m_wPage, m_hPage);
                if (printableThing.print(g, pageFormat, pageIndex) !=
                        Printable.PAGE_EXISTS) {
                    System.out.println(
                            "pageIndex=" +
                            pageIndex +
                            " does not exist");
                    break;

                }

                previewPanel.add(new PagePreview(this, w, h, img));
                pageIndex++;
            }
        } catch (PrinterException e) {
            e.printStackTrace();
            System.err.println("Printing error: " + e.toString());
        }

        JScrollPane ps = new JScrollPane(previewPanel);
        getContentPane().add(ps, BorderLayout.CENTER);

        setDefaultCloseOperation(DISPOSE_ON_CLOSE);
        setVisible(true);
    }

    private void doPrintButton() {
        try {
            PrinterJob prnJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat = prnJob.defaultPage();
            pageFormat.setOrientation(m_orientation);
            prnJob.setPrintable(target, pageFormat);

            if (!prnJob.printDialog())
                return;
            setCursor(
                    Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
            prnJob.print();
            setCursor(
                    Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
            dispose();
        } catch (PrinterException ex) {
            ex.printStackTrace();
            System.err.println("Printing error: " + ex.toString());
        }
    }

}

