/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package addbk.print.labels;

import javax.swing.*;
import java.awt.*;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 30, 2005
 * <p/>
 * Time: 1:34:10 AM
 */
class PreviewPanel
        extends JPanel {
    protected int H_GAP = 16;
    protected int V_GAP = 10;
    private PrintPreview printPreview;

    public PreviewPanel(PrintPreview printPreview) {
        this.printPreview = printPreview;
    }

    public Dimension getPreferredSize() {
        int n = printPreview.getComponentCount();
        if (n == 0)
            return new Dimension(H_GAP, V_GAP);
        Component comp = printPreview.getComponent(0);
        Dimension dc = comp.getPreferredSize();
        int w = dc.width;
        int h = dc.height;

        Dimension dp = printPreview.getParent().getSize();
        int nCol = Math.max((dp.width - H_GAP) / (w + H_GAP), 1);
        int nRow = n / nCol;
        if (nRow * nCol < n)
            nRow++;

        int ww = nCol * (w + H_GAP) + H_GAP;
        int hh = nRow * (h + V_GAP) + V_GAP;
        Insets ins = getInsets();
        return new Dimension(
                ww + ins.left + ins.right,
                hh + ins.top + ins.bottom);
    }

    public Dimension getMaximumSize() {
        return getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return getPreferredSize();
    }

    public void doLayout() {
        Insets ins = getInsets();
        int x = ins.left + H_GAP;
        int y = ins.top + V_GAP;

        int n = printPreview.getComponentCount();
        if (n == 0)
            return;
        Component comp = printPreview.getComponent(0);
        Dimension dc = comp.getPreferredSize();
        int w = dc.width;
        int h = dc.height;

        Dimension dp = printPreview.getParent().getSize();
        int nCol = Math.max((dp.width - H_GAP) / (w + H_GAP), 1);
        int nRow = n / nCol;
        if (nRow * nCol < n)
            nRow++;

        int index = 0;
        for (int k = 0; k < nRow; k++) {
            for (int m = 0; m < nCol; m++) {
                if (index >= n)
                    return;
                comp = printPreview.getComponent(index++);
                comp.setBounds(x, y, w, h);
                x += w + H_GAP;
            }
            y += h + V_GAP;
            x = ins.left + H_GAP;
        }
    }
}
