/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package addbk.JAddressBook;

import futils.Futil;
import gui.ClosableJFrame;
import gui.In;
import gui.layouts.VerticalFlowLayout;
import gui.run.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;


/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 10, 2005
 * <p/>
 * Time: 6:30:24 AM
 */

public class IndexPanel
        implements Runnable, Observer {
    private AddressDataBase adb = AddressDataBase.getAddressBookDatabase();
    private RunLabelRecord rl[] =
            new RunLabelRecord[getNumberOfRows()];

    private Font labelFont = new Font("Times", Font.PLAIN, 12);
    private LabelBean labelBean = LabelBean.restore();
    private DialBean dialBean = DialBean.restore();
    private SerialPortBean serialPortBean = SerialPortBean.restore();
    private static IndexPanel indexPanel = new IndexPanel();
    private final JPanel jPanel = new JPanel();

    public IndexPanel() {
        jPanel.setLayout(new BorderLayout());
        jPanel.add(getLabelPanel(), BorderLayout.CENTER);
        jPanel.add(getButtonControlPanel(), BorderLayout.SOUTH);
        jPanel.add(getLetterPanel(), BorderLayout.EAST);
        adb.addObserver(this);
    }

    private int getNumberOfRows() {
        return 19 * 3; //19 rowsx3columns
    }

    public void update(Observable obs, Object obj) {
        updateLabels();
    }

    AddressRecord getValue() {
        return adb.getCurrentRecord();
    }


    ViewPanel vp = new ViewPanel() {
        public void run() {

        }
    };
    ClosableJFrame viewFrame = getViewFrame();


    private JPanel getButtonControlPanel() {
        JPanel jp = new JPanel();

        jp.setLayout(new FlowLayout());
        jp.add(
                new RunButton("find") {
                    public void run() {
                        showFindFrame();
                    }
                });
        jp.add(
                new RunButton("prev") {
                    public void run() {
                        adb.previous(getNumberOfRows());
                    }
                });
        jp.add(
                new RunButton("next") {
                    public void run() {
                        adb.next(getNumberOfRows());
                    }
                });
        jp.add(
                new RunButton("edit") {
                    public void run() {
                        edit();
                    }
                });
        return jp;
    }

    public void showFindFrame() {
        adb.top();
        JFrame f = getFindFrame();
        f.setLocation(jPanel.getSize().width, 0);
        f.setVisible(true);
    }

    private JFrame getFindFrame() {
        final ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.add(
                new RunFindPanel() {
                    public void run() {
                        find(getFindBean());
                    }

                    public void doExit() {
                        cf.setVisible(false);
                    }
                });
        cf.setSize(250, 150);
        return cf;
    }

    private void find(FindBean findBean) {
        AddressRecord ar = adb.find(findBean);
        if (ar == null) {
            In.message("address not found");
            return;
        }
        setValue(ar);

    }

    private JPanel getLetterPanel() {
        JPanel jp = new JPanel() {
            public Dimension getPreferredSize() {
                return new Dimension(20, 100);
            }

            public Dimension getMinimumSize() {
                return getPreferredSize();
            }
        };
        jp.setLayout(new GridLayout(0, 1));
        for (int j = 0; j < 26; j++)
            jp.add(
                    new RunLabel("  " + (char) (('a' + j)) + "") {
                        public void run() {
                            adb.findLetter(getText());
                        }
                    });
        return jp;
    }

    public static String getShortName(AddressRecord ar) {
        String s = ar.getName();
        if (s.length() < 20) return s;
        return s.substring(0, 20);
    }

    public static void startPrintThread() {
        Thread t = new Thread(
                new Runnable() {
                    public void run() {
                        AddressDataBase adb = AddressDataBase.getAddressBookDatabase();
                        FontBean fb = FontBean.restore();
                        Font f = fb.getFont();
                        new LabelPrinter(adb, f);

                    }
                });
        t.setPriority(Thread.MIN_PRIORITY);
        t.start();
    }

    public static void openGzDataBase(final IndexPanel indexPanel) {
        try {
            final File readFile = Futil.getReadFile("select a gz db");
            if (readFile == null) return;
            indexPanel.adb.openGzDb(
                    readFile
                    .getAbsolutePath());
            indexPanel.updateLabels();
        } catch (IOException e) {
            In.message(e);

        }
    }

    public static RunMenu getPreferenceMenu(final IndexPanel indexPanel) {
        RunMenu rm = new RunMenu("[Prefs");
        rm.add(
                new RunMenuItem("Label [Fonts...") {
                    public void run() {
                        indexPanel.labelFont = indexPanel.getLabelFont();
                    }
                });
        rm.add(
                new RunMenuItem("Label [Dimensions...") {
                    public void run() {
                        indexPanel.labelBean = indexPanel.getLabelBean();
                    }
                });
        rm.add(new RunDialPreferenceMenu(indexPanel));
        rm.add(new RunSerialPortMenu(indexPanel));
        return rm;
    }

    public void save() {
        try {
            adb.save();
        } catch (IOException e) {
            In.message(e);

        }
    }

    public void clearDatabase() {
        adb.init();
        updateLabels();
    }

    public static IndexPanel getRunIndexPanel() {
        return indexPanel;
    }


    public void delete() {
        adb.deleteCurrentRecord();       
    }

    public void updateLabels() {
        AddressRecord ar[] = adb.getNextRecords(getNumberOfRows());
        for (int i = 0; i < ar.length; i++)
            rl[i].setValue(ar[i]);
        updateBorders(adb.getCurrentRecord());
    }


    private void setValue(AddressRecord value) {
        adb.findRecordAndSetToCurrentNoUpdate(value);
        updateBorders(value);
    }

    private void updateBorders(AddressRecord value) {
        for (int j = 0; j < getNumberOfRows(); j++) {
            RunLabelRecord rlr = rl[j];
            if (rlr.getValue() == value)
                rlr.setBorder(BorderFactory.createEtchedBorder());
            else
                rlr.setBorder(BorderFactory.createEmptyBorder());
        }
    }


    private JPanel getLabelPanel() {
        JPanel jp = new JPanel();
        int n = adb.getSize();
        int recordNumber=0;
        jp.setLayout(new VerticalFlowLayout(0, 5));
        for (int j = 0; j < getNumberOfRows(); j++) {
            AddressRecord nextRecord = adb.getNextRecord();
            // If you don't have enough records to display,
            // just get place holders
            recordNumber++;
            if (recordNumber >= n){
                nextRecord = new AddressRecord();
            }
            final RunLabelRecord runLabel =
                    new RunLabelRecord(nextRecord) {
                        public void run() {
                            IndexPanel.this.setValue(getValue());
                        }
                    };
            runLabel.addMouseListener(
                    new MouseAdapter() {
                        public void mouseClicked(MouseEvent e) {
                            if (e.getClickCount() == 2)
                                view(runLabel);
                        }
                    });
            rl[j] = runLabel;
            jp.add(runLabel);
        }
        return jp;
    }

    public void view(RunLabelRecord rld) {
        vp.setValue(rld.getValue());
        viewFrame.setVisible(true);
    }

    private ClosableJFrame getViewFrame() {
        ClosableJFrame viewFrame = new ClosableJFrame();
        viewFrame.setJMenuBar(getRunMenuBar());
        viewFrame.addComponent(vp);
        viewFrame.setSize(400, 400);
        return viewFrame;
    }

    public RunMenuBar getRunMenuBar() {
        RunMenuBar rmb = new RunMenuBar();

        rmb.add(FileMenu.getFileMenu(this));
        rmb.add(EditMenu.getEditMenu(this));

        return rmb;
    }

    private SerialPortBean getSerialPortBean() {
        final JDialog jd = new JDialog();
        jd.setModal(false);
        Container c = jd.getContentPane();
        c.setLayout(new BorderLayout());
        c.add(
                new RunSerialPortPanel() {
                    public void run() {
                        IndexPanel.this.serialPortBean = getValue();
                        jd.setVisible(false);

                    }
                });
        jd.pack();
        jd.setVisible(true);
        return serialPortBean;
    }

    private DialBean getDialBean() {
        final JDialog jd = new JDialog();
        jd.setModal(true);
        Container c = jd.getContentPane();
        c.setLayout(new BorderLayout());
        c.add(
                new RunDialPanel() {
                    public void run() {
                        IndexPanel.this.dialBean = getValue();
                        jd.setVisible(false);

                    }
                });
        jd.pack();
        jd.setVisible(true);
        return dialBean;
    }

    private LabelBean getLabelBean() {
        final JDialog jd = new JDialog();
        jd.setModal(true);
        Container c = jd.getContentPane();
        c.setLayout(new BorderLayout());
        c.add(
                new RunLabelPanel() {
                    public void run() {
                        IndexPanel.this.labelBean = getValue();
                        jd.setVisible(false);
                    }
                });
        jd.pack();
        jd.setVisible(true);
        return labelBean;
    }

    private Font getLabelFont() {
        final JDialog jd = new JDialog();
        jd.setModal(true);
        Container c = jd.getContentPane();
        c.setLayout(new BorderLayout());
        c.add(
                new RunFontPanel() {
                    public void run() {
                        IndexPanel.this.labelFont = getValue();
                        jd.setVisible(false);
                    }
                });
        jd.pack();
        jd.setVisible(true);
        return labelFont;
    }

    public void newRecord() {
        final ClosableJFrame cf = new ClosableJFrame();
        NewRecordPanel co = new NewRecordPanel() {
            public void run() {
                cf.setVisible(false);
                vp.setValue(getValue());
            }
        };
        cf.addComponent(co);
        cf.setSize(400, 400);
        cf.setVisible(true);
    }
 

    public void edit() {
        final ClosableJFrame cf = new ClosableJFrame();
        EditPanel co = new EditPanel() {
            public void run() {
                cf.setVisible(false);
                vp.setValue(getValue());
                IndexPanel.this.updateLabels();
            }
        };
        co.setValue(adb.getCurrentRecord());
        cf.addComponent(co);
        cf.setSize(400, 400);
        cf.setVisible(true);
    }

    public void run() {
        updateLabels();
    }

    public static void main(String[] args) {
        showRunIndexFrame();

    }

    private static final ClosableJFrame indexFrame = new ClosableJFrame();

    public static void setIndexFrameVisible(boolean b) {
        indexFrame.setVisible(b);

    }



    private static void showRunIndexFrame() {


        indexFrame.setJMenuBar(indexPanel.getRunMenuBar());
        indexFrame.addComponent(indexPanel.jPanel);
        indexFrame.setSize(400, 400);
        indexFrame.setVisible(true);
    }


    private static class RunDialPreferenceMenu extends RunMenuItem {
        private final IndexPanel indexPanel;

        public RunDialPreferenceMenu(IndexPanel indexPanel) {
            super("Dial [Setup...");
            this.indexPanel = indexPanel;
        }

        public void run() {
            indexPanel.dialBean = indexPanel.getDialBean();
        }
    }

    private static class RunSerialPortMenu extends RunMenuItem {
        private final IndexPanel indexPanel;

        public RunSerialPortMenu(IndexPanel indexPanel) {
            super("Serial [port Setup...");
            this.indexPanel = indexPanel;
        }

        public void run() {
            indexPanel.serialPortBean = indexPanel.getSerialPortBean();
        }
    }
}
