/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package addbk.JAddressBook;

import gui.run.RunMenu;
import gui.run.RunMenuItem;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jun 4, 2005
 * <p/>
 * Time: 11:05:09 AM
 */
public class FileMenu {
    private static AddressDataBase adb = AddressDataBase.getAddressBookDatabase();
    public static RunMenu getFileMenu(final IndexPanel indexPanel) {
        RunMenu fileMenu =
                new RunMenu("[File");
        fileMenu.add(
                new RunMenuItem("[Clear Database{Alt Control c}") {
                    public void run() {
                        indexPanel.clearDatabase();
                    };
                });
        fileMenu.add(
                new RunMenuItem("[open gzipped db...") {
                    public void run() {
                        IndexPanel.openGzDataBase(indexPanel);
                    };
                });
        fileMenu.add(
                new RunMenuItem("save gzipped db...") {
                    public void run() {
                        adb.saveGzippedDb();
                    };
                });
        fileMenu.add(
                new RunMenuItem("[save{control s}") {
                    public void run() {
                        indexPanel.save();
                    };
                });
        fileMenu.add(new MergeMenu());
        fileMenu.add(new ExportMenu());
        fileMenu.add(new DataMiningMenu(indexPanel));
        fileMenu.add(
                new RunMenuItem("[print avery 5160 labels...") {
                    public void run() {
                        IndexPanel.startPrintThread();
                    }
                });
        fileMenu.add(
                new RunMenuItem("[quit{control q}") {
                    public void run() {
                        System.exit(0);
                    };
                });
        return fileMenu;
    }
}
