/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package addbk.JAddressBook;

import gui.run.RunMenu;
import gui.run.RunMenuItem;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Jun 4, 2005
 * <p/>
 * Time: 10:56:00 AM
 */
public class EditMenu {
    public static RunMenu getEditMenu(final IndexPanel indexPanel) {
        RunMenu rm =
                new RunMenu("[Edit");
        rm.add(CopyMenu.getCopyMenu());
        rm.add(
                new RunMenuItem("[New{control n}") {
                    public void run() {
                        indexPanel.newRecord();
                    };
                });
        rm.add(
                new RunMenuItem("[Edit Record{control e}") {
                    public void run() {
                        indexPanel.edit();
                    };
                });
        rm.add(new RunMenuItem("[Delete {control d}") {
            public void run() {
                indexPanel.delete();
            };
        });
        rm.add(
                new RunMenuItem("[Find{control f}") {
                    public void run() {
                        indexPanel.showFindFrame();
                    };
                });
        rm.add(IndexPanel.getPreferenceMenu(indexPanel));
        rm.add(
                new RunMenuItem("[Help") {
                    public void run() {
                        Help h = new Help();
                        h.display();
                    }
                });
        return rm;
    }
}
