package xml.fixJJL;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import java.io.*;
import java.beans.XMLDecoder;

import futils.Futil;
import gui.In;
import xml.adbk.AddressBook;
import xml.adbk.ParseAml;

/**
 * xml.Xml2Address reads AML and makes address books.
 */

public class Main {

    public static void main(String argv [])
            throws IOException {
        try {
            ExcelXml2Cboe.getCboe();

        } catch (SAXParseException e) {
            System.out.println("** Parsing error"
                    + ", line " + e.getLineNumber()
                    + ", uri " + e.getSystemId()
                    + "   " + e.getMessage());

        } catch (SAXException e) {
            e.printStackTrace();
        } catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

//    public static void main(String[] args) {
//        System.out.println("Start Main");
//        File f = Futil.getReadFile("select an xml file");
//        try {
//            XMLDecoder d = new XMLDecoder(new BufferedInputStream(new FileInputStream("Test.xml")));
//            Object result = d.readObject();
//            d.close();
//        } catch (FileNotFoundException e) {
//            System.out.println("file not found");
//        }
//
//        try {
//            String uri = f.toURL().toString();
//            In.message("uri="+uri);
//            read(uri);
//        } catch (SAXException e) {
//            e.printStackTrace();
//
//        } catch (ParserConfigurationException e) {
//            e.printStackTrace();
//
//        } catch (IOException e) {
//            e.printStackTrace();
//
//        }
//    }
    public static Cboe read(String uri)
            throws
            SAXParseException,
            SAXException,
            ParserConfigurationException,
            IOException {

        SAXParserFactory spf
                = SAXParserFactory.newInstance();
        spf.setValidating(true);

        SAXParser sp = spf.newSAXParser();

        FixDataHandler dh = new FixDataHandler();
        sp.parse(uri, dh);
        return dh.getCboe();
    }

}


