package xml.fixJJL;

import org.xml.sax.helpers.DefaultHandler;

import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

import gui.In;

//import java.sql.Date;

//import xml.adbk.AddressBook;
//import xml.adbk.Address;
//import xml.Product;

/**
 * FixDataHandler is a <code></code>
 * that can parse CBOE file saved from Exel
 */
public class FixDataHandler
        extends DefaultHandler {

    private Cboe cboe = new Cboe();
    //   private CboeInput a = new CboeInput();
    private Vector stringVector = new Vector();
    private static int rowNum = 0;
    private static int dataField = 0;

    public Cboe getCboe() {
        for (int i = 0; i < cboe.getRecordNumber(); i++) {
            //CboeRec cboer = new CboeRec();
            CboeRec cboer = cboe.getRecordAt(i);
            System.out.println("rec:" + i + ": " + cboer.toCsvString());
        }
        return cboe;
    }

    /**
     * The Locator  instance must be
     * used locally to identify
     * the origin of a SAX event.
     */
    //public void setDocumentLocator(Locator l) {
    //}

    // public void startDocument()
    //     throws SAXException {
    // }

    // public void endDocument()
    //    throws SAXException {
    //}

    public void startElement() {
    }

    /**
     * When we get the </Row> tag, then
     * we want to invoke
     * addProduct otherwise, just return:
     */
//    public void endElement(String name) {
//        if (!name.equals("Row")) return;
//        addCboeRec();
//    }
    public void incRowNum() {
        rowNum = rowNum + 1;
    }

    public void incDataField() {
        dataField = dataField + 1;
    }
    /*
     * addCboeRec will
     * make an instance of a
     * CboeRec class and add it to the
     * Cboe instance. It is added by parsing
     * the last 5 strings that
     * have been pushed into the StringVector.
     */

    public void addCboeRec() {
        String sa[] = new String[stringVector.size()];
        stringVector.copyInto(sa);
        // if (sa.length < 11) return;
        System.out.println("sa.length" + sa.length);
        //Date tradeDate = Date.valueOf(sa[0]);
        //  String tradeDate = (String)sa[2];
        //  String putVolume = sa[4];
        // String callVolume = sa[6];
        // String totalVolume = sa[8];
        // String putCallRatio = sa[10];
        double putCallRatio;
        int totalVolume;
        int callVolume;
        int putVolume;
        Date tradeDate;
        popLastValue();
        /*
        <Row>
    <Cell ss:StyleID="s21"><Data ss:Type="DateTime">2003-10-21T00:00:00.000</Data></Cell>
    <Cell><Data ss:Type="Number">773759</Data></Cell>
    <Cell><Data ss:Type="Number">540023</Data></Cell>
    <Cell><Data ss:Type="Number">1313782</Data></Cell>
    <Cell><Data ss:Type="Number">0.7</Data></Cell>
   </Row>
        */
        try {
            putCallRatio = Double.parseDouble(popLastValue());
        } catch (NumberFormatException e) {
            putCallRatio = 0.0;
        }
        popLastValue();
        try {
            totalVolume = Integer.parseInt(popLastValue());
        } catch (NumberFormatException e) {
            totalVolume = 0;
        }
        popLastValue();
        try {
            callVolume = Integer.parseInt(popLastValue());
        } catch (NumberFormatException e) {
            callVolume = 0;
        }
        popLastValue();
        try {
            putVolume = Integer.parseInt(popLastValue());
        } catch (NumberFormatException e) {
            putVolume = 0;
        }
        popLastValue();
        tradeDate = getDate(popLastValue());

//        int putVolume = Integer.valueOf(sa[4]).intValue();
//        int callVolume = Integer.valueOf(sa[6]).intValue();
//        int totalVolume = Integer.valueOf(sa[8]).intValue();
//        int putCallRatio = Integer.valueOf(sa[10]).intValue();

        CboeRec cr
                //  = new CboeRec("test date",1, 2,3, 4);
                = new CboeRec(tradeDate, putVolume, callVolume, totalVolume,
                        putCallRatio);
        System.out.println("cr = " + cr.toCsv());
        //   System.out.println("cr = "+cr.toXml());
        cboe.addCboeRec(cr);
        stringVector = new Vector();
    }

    /**
     * when characters are found, we add them to
     * the string vector for latter use.
     */
    public void characters(char buf [], int offset, int len) {
        stringVector.addElement(new String(buf, offset, len));
    }

    public void ignorableWhitespace(char buf [], int offset, int len) {
    }

    /**
     * The processingInstruction is
     * called back when a non XML
     * declaration is made.
     */
    public void processingInstruction(String target,
                                      String data) {
    }

    public String popLastValue() {
        if (stringVector.size() == 0) return null;
        String lv = (String) stringVector.elementAt(stringVector.size() - 1);
        stringVector.removeElementAt(stringVector.size() - 1);
        return lv;
    }

    public String getLastValue() {
        if (stringVector.size() == 0) return null;

        return (String) stringVector.elementAt(stringVector.size() - 1);
    }

    public void endElement(String s1, String s2, String name) {
        System.out.println("name=" + name);
        String sa[] = new String[stringVector.size()];
        stringVector.copyInto(sa);

        if (name.equals("Row")) {
            incRowNum();
            if (rowNum > 2) {
                //  if (rowNum == 1) {
                //     1st row is just Total Volume header title
                //  if (rowNum == 2) {
                //     Skip 2nd row of String headers
                //  if (rowNum>2 )  Process data values
                if (dataField != 5)    // should have all 5 data fields in each row
                    System.out.println("Less than 5 data fields in row "
                            + rowNum + " fields" + dataField);
                addCboeRec();
            }
            dataField = 0;  // reset to start a new record
        }
        if (name.equals("Data")) {
            dataField = dataField + 1;
        }

    }

    // public void addAddressRecord() {
    //     System.out.println("adding record:" + a.toXml());
    //    ab.addAddress(a);
    //   a = new Address();
    // }

    /**
     * when characters are found, we add them to
     * the string vector for latter use.
     */
    public static void main(String[] args) {
        System.out.println(getDate("2003-10-21T00:00:00.000"));
    }

    private static Date getDate(String s) {
        Calendar c = null;
        try {
            String yearString = s.substring(0, 4);
            String monthString = s.substring(5, 7);
            String dateString = s.substring(8, 10);
            c = Calendar.getInstance();
            c.set(Integer.parseInt(yearString),
                    Integer.parseInt(monthString) - 1,
                    Integer.parseInt(dateString),0,0,0);
        } catch (Exception e) {
            In.message("warning:Bad Date="+s);
            return new Date();

        }
        return c.getTime();
    }


}
