package xml.fixJJL;

import org.xml.sax.SAXParseException;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;

import futils.Futil;

/**
 * Created by IntelliJ IDEA.
 * User: John
 * Date: Mar 22, 2005
 * Time: 9:30:57 PM
 * To change this template use File | Settings | File Templates.
 */
public class ExcelXml2Cboe {

    public static void main(String argv [])
            throws IOException {
        try {

            getCboe();


        } catch (SAXParseException e) {
            System.out.println("** Parsing error"
                    + ", line " + e.getLineNumber()
                    + ", uri " + e.getSystemId()
                    + "   " + e.getMessage());

        } catch (SAXException e) {
            e.printStackTrace();
        } catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }


    public static void getCboe()
            throws SAXParseException, SAXException,
            ParserConfigurationException, IOException {
        System.out.println(" Start ExcelXml2Cboe getCboe");
        Cboe c = read(
                Futil.getReadFile("select an XML file").toURI());
        //System.out.println("c = "+c.toXml());
        // System.out.println("CboeInput=" + c);
        //  xml.Utils.writeXml((Serializable) c);
        //  c.saveAsXml(  Futil.getReadFile(
        //                     "select an XML file").getAbsolutePath()););
        //  System.out.println(c.toString()+"</java>");
    }


    public static Cboe read(URI uri)
            throws SAXParseException,
            SAXException,
            ParserConfigurationException,
            IOException {
        Cboe returnCboe = new Cboe();
        System.out.println("In read uri = " + uri);
        SAXParserFactory spf =
                SAXParserFactory.newInstance();
        spf.setValidating(true);
        SAXParser sp = spf.newSAXParser();

        FixDataHandler dh = new FixDataHandler();
        sp.parse(uri.toString(), dh);
        returnCboe = dh.getCboe();
        //  returnCboe.toXml();
        returnCboe.saveAsXml(Futil.getWriteFile("select an XML Output file"));
        System.out.println("completed write to file");
        return returnCboe;
    }
}
