package xml.fixJJL;

import java.io.Serializable;
import java.io.ByteArrayOutputStream;
import java.beans.XMLEncoder;
import java.util.Date;


/**
 * Created by IntelliJ IDEA.
 * User: John
 * Date: Mar 22, 2005
 * Time: 10:33:23 PM
 * To change this template use File | Settings | File Templates.
 */
public class CboeRec implements
        Serializable {
    private Date tradeDate;
    private int putVolume;
    private int callVolume;
    private int totalVolume;
    private double putCallRatio;

    public CboeRec() {
        setTradeDate(null);
        setPutVolume(0);
        setCallVolume(0);
        setTotalVolume(0);
        setPutCallRatio(0);
    }

    public CboeRec(Date td, int pv, int cv, int tv, double pcr) {
        setTradeDate(td);
        setPutVolume(pv);
        setCallVolume(cv);
        setTotalVolume(tv);
        setPutCallRatio(pcr);
    }

    public String toCsvString() {
        String s = new String();
        s = s + this.getTradeDate() + "," +
                this.getPutVolume() + "," +
                this.getCallVolume() + "," +
                this.getTotalVolume() + "," +
                this.getPutCallRatio();
        return s;
    }

    public String toCsv() {
        StringBuffer sb = new StringBuffer("");
        sb.append(tradeDate + ",");
        sb.append(this.getPutVolume() + ",");
        sb.append(callVolume + ",");
        sb.append(totalVolume + ",");
        sb.append(putCallRatio);
        return sb.toString() + "\n";
    }

    public String toXml() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEncoder e = new XMLEncoder(baos);
        e.writeObject(this);
        e.flush();
        return baos.toString();
    }

    public Date getTradeDate() {
        return tradeDate;
    }

    public void setTradeDate(Date tradeDate) {
        this.tradeDate = tradeDate;
    }

    public int getPutVolume() {
        return putVolume;
    }

    public void setPutVolume(int putVolume) {
        this.putVolume = putVolume;
    }

    public int getCallVolume() {
        return callVolume;
    }

    public void setCallVolume(int callVolume) {
        this.callVolume = callVolume;
    }

    public int getTotalVolume() {
        return totalVolume;
    }

    public void setTotalVolume(int totalVolume) {
        this.totalVolume = totalVolume;
    }

    public double getPutCallRatio() {
        return putCallRatio;
    }

    public void setPutCallRatio(double putCallRatio) {
        this.putCallRatio = putCallRatio;
    }
}
