package xml.adbk;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import java.io.IOException;
import java.io.File;

import futils.Futil;
import gui.In;

/**
 * xml.Xml2Address reads AML and makes address books.
 */

public class Xml2Address {
    public static void main(String[] args) {
        File f = Futil.getReadFile("select an xml file");
        try {
            String uri = f.toURL().toString();
            In.message("uri="+uri);
            read(uri);
        } catch (SAXException e) {
            e.printStackTrace();

        } catch (ParserConfigurationException e) {
            e.printStackTrace();

        } catch (IOException e) {
            e.printStackTrace();

        }
    }
    public static AddressBook read(String uri)
            throws
            SAXParseException,
            SAXException,
            ParserConfigurationException,
            IOException {

        SAXParserFactory spf
                = SAXParserFactory.newInstance();
        spf.setValidating(true);

        SAXParser sp = spf.newSAXParser();

        ParseAml dh = new ParseAml();
        sp.parse(uri, dh);
        return dh.getAddressBook();
    }

}


