package video.neuquant;

import j2d.ImageUtils;
import utils.CompactJava;

import java.awt.*;
import java.io.*;
import java.util.prefs.Preferences;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Dec 8, 2004
 * Time: 8:06:45 PM
 */
public class NeuquantCaptureBean implements Serializable {
    private boolean isSilentOnCapture = false;
    private double playBackSecondsPerFrame = 1;
    private double recordSecondsPerFrame = 1;
    private boolean isLooped = true;
    private boolean isBuffered = false;
    private boolean isEntireScreen = true;
    private String outputFile = null;
    private Rectangle inputRectangle = ImageUtils.getFullScreen();
    private Dimension outputSize =
            new Dimension((int) inputRectangle.getWidth(),
                    (int) inputRectangle.getHeight());
    private static String key = "NeuquantCaptureBeanProps";
    private boolean running = false;
    private boolean silent = true;
    private boolean manual = false;

    public String toXml() {
        return CompactJava.toXml(this) + "</java>";
    }

    public String toString() {
        return toXml();
    }

    public static void main(String[] args) {
        NeuquantCaptureBean ncb = NeuquantCaptureBean.restore();
        System.out.println(ncb);
        ncb.setLooped(false);
        ncb.save();
    }

    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save() {
        try {
            Preferences p = Preferences.userRoot();
            ByteArrayOutputStream baos = new
                    ByteArrayOutputStream();
            ObjectOutputStream oos = new
                    ObjectOutputStream(baos);
            oos.writeObject(this);
            baos.close();
            p.putByteArray(key, baos.toByteArray());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * restores the properties from the preference in
     * the user root.
     */
    public static NeuquantCaptureBean restore() {
        try {
            Preferences p = Preferences.userRoot();
            byte b [] = p.getByteArray(key, null);
            if (b == null)
                return new NeuquantCaptureBean();
            ByteArrayInputStream bais = new
                    ByteArrayInputStream(b);
            ObjectInputStream ois = new
                    ObjectInputStream(bais);
            Object o = ois.readObject();
            bais.close();
            return (NeuquantCaptureBean) o;
        } catch (IOException e) {
        } catch (ClassNotFoundException e) {
        }
        return new NeuquantCaptureBean();
    }

    public boolean isSilentOnCapture() {
        return isSilentOnCapture;
    }

    public void setSilentOnCapture(boolean silentOnCapture) {
        isSilentOnCapture = silentOnCapture;
    }

    public double getPlayBackSecondsPerFrame() {
        return playBackSecondsPerFrame;
    }

    public void setPlayBackSecondsPerFrame(double playBackSecondsPerFrame) {
        this.playBackSecondsPerFrame = playBackSecondsPerFrame;
    }

    public boolean isLooped() {
        return isLooped;
    }

    public void setLooped(boolean looped) {
        isLooped = looped;
    }

    public boolean isBuffered() {
        return isBuffered;
    }

    public void setBuffered(boolean buffered) {
        isBuffered = buffered;
    }

    public boolean isEntireScreen() {
        return isEntireScreen;
    }

    public void setEntireScreen(boolean entireScreen) {
        isEntireScreen = entireScreen;
    }

    public Rectangle getInputRectangle() {
        return inputRectangle;
    }

    public void setInputRectangle(Rectangle inputRectangle) {
        this.inputRectangle = inputRectangle;
    }

    public Dimension getOutputSize() {
        return outputSize;
    }

    public void setOutputSize(Dimension outputSize) {
        this.outputSize = outputSize;
    }

    public String getOutputFile() {
        return outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public boolean isValidData() {
        return true; // do error checking here....
    }

    public boolean isRunning() {
        return
                running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isSlient() {
        return silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean isManual() {
        return manual;
    }

    public void setManual(boolean manual) {
        this.manual = manual;
    }

    public double getRecordSecondsPerFrame() {
        return recordSecondsPerFrame;
    }

    public void setRecordSecondsPerFrame(double recordSecondsPerFrame) {
        this.recordSecondsPerFrame = recordSecondsPerFrame;
    }
}
