package video.neuquant;

import futils.Futil;
import gui.In;
import gui.dialogs.ProgressDialog;
import j2d.ImageUtils;
import ip.gif.neuquantAnimation.AnimatedGifEncoder;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Vector;

import ip.gif.neuquantAnimation.AnimatedGifEncoder;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Nov 26, 2004
 * <p/>
 * Time: 9:05:43 AM
 */
public class NeuquantCapture {
    public static void main(String[] args) {
        streamScreenNeuquantImagesToAFile();
    }

    /**
     * This is very memory efficient, and, if it works fast enough, it
     * should be ok for your application. However, it is slow, for large
     * images. Todo: build a nice interface, with a cool dialog Even though
     * it is small in size, a rectangular area takes way too long to
     * digitize in a stream. Generally around 3 or 4 seconds per image.
     * Streaming generally results in an image that is 40k per image at
     * 800x600. This is a 12:1 compression ratio. There is more work for
     * the algorithm when the image changes more. A threaded stream for the
     * output might be a good way to handle this.
     */
    public static void streamScreenNeuquantImagesToAFile() {
        File f = Futil.getWriteFile("select gif output file");
        Rectangle inputRect = ImageUtils.getFullScreen();

        if (!In.getBoolean("capture whole screen?"))
            inputRect = In.getRectangle("select active area");
        int n = In.getInt("how many frames?");
        long d = In.getInt("enter delay in ms");
        AnimatedGifEncoder age = new AnimatedGifEncoder();
        if (In.getBoolean("loop on playback?"))
            age.setRepeat(0);
        age.setDelay((int) d);
        age.start(f.toString());
        boolean isBuffered = In.getBoolean("buffer before save");
        Dimension outputDim = getOutputSize(inputRect);
        In.message("click to begin");

        try {
            neuquantImageStreamToAFile(d,
                    n,
                    inputRect,
                    outputDim,
                    age,
                    isBuffered);
        } catch (AWTException e) {
            e.printStackTrace();

        }

        age.finish();
        System.out.println("done!");
        In.message("done with capture");

    }

    private static Dimension getOutputSize(Rectangle inputRect) {
        boolean b = In.getBoolean("would you to scale the output?");
        Dimension output = new Dimension((int) inputRect.getWidth(),
                (int) inputRect.getHeight());
        if (!b) return output;
        b = In.getBoolean("would you like fixed-size resampling?");
        if (!b) {
            Rectangle outputRect = In.getRectangle("select new output Height");
            return new Dimension(-1, (int) outputRect.getHeight());
        }
        String options[] = {"1/2","1/4","1/8"};
        String selected =
                (String)In.multiPrompt(options,"scale width and height by","scale dialog");
        int h = (int) inputRect.getHeight();
        if (selected.equals("1/2")) h = h / 2;
        if (selected.equals("1/4")) h = h / 4;
        if (selected.equals("1/8")) h = h / 8;
        return new Dimension(-1, h);
    }

    /**
     * Call this method to save images to a file, slowly, compressing as we
     * go. It is typical for the process to take 13 seconds per frame on a
     * 800 Mhz mac. Wow.
     *
     * @param delayBetweenFrames used on playback. Also, if the capture
     *                           program actually takes less time than the
     *                           delay, it will add the different to the
     *                           sleep time between frames.
     * @param numberOfFrames     total number of frames to capture
     * @param inputRect          size of the capture area.
     * @param age                neuquant codec.
     * @throws java.awt.AWTException
     */
    public static void neuquantImageStreamToAFile(long delayBetweenFrames,
                                                  int numberOfFrames,
                                                  Rectangle inputRect,
                                                  Dimension outputDim,
                                                  AnimatedGifEncoder age,
                                                  boolean isBuffered)
            throws AWTException {
        Robot robot = new Robot();
        long delta = 0;
        long now = 0;
        BufferedImage bi = null;
        Vector v = new Vector();
        for (int i = 0; i < numberOfFrames; i++) {
            now = System.currentTimeMillis();

            bi = grabScreen(robot, inputRect);
            bi =
                    ImageUtils.scaleFast(bi,
                            outputDim.width,
                            outputDim.height);
            if (isBuffered)
                v.addElement(bi);
            else
                addImageToEncoder(age, bi);
            delta = delayBetweenFrames -
                    (System.currentTimeMillis() - now);
            System.out.println("delta is" + delta);
            if (delta < 0) continue; // can't keep up!
            sleep(delta);
        }
        if (isBuffered) {
            ProgressDialog pd = ProgressDialog.getInstance();
            pd.setTitle("saving images...");
            pd.setVisible(true);
            final int n = v.size();
            for (int i = 0; i < n; i++) {
                pd.setAmountDone(i * 100 / n);
                addImageToEncoder(age, (BufferedImage) v.elementAt(i));
            }
            pd.setVisible(false);
        }
    }
    public static void neuquantImageStreamToAFile(NeuquantCaptureBean ncb)
            throws AWTException {
        Robot robot = new Robot();
        long delta = 0;
        long now = 0;
        BufferedImage bi = null;
        Dimension outputDim = ncb.getOutputSize();
        AnimatedGifEncoder age = new AnimatedGifEncoder();
        age.setDelay((int)(ncb.getPlayBackSecondsPerFrame()*1000));
        if (ncb.isLooped())
            age.setRepeat(0);
        age.start(ncb.getOutputFile());
        Vector v = new Vector();
        while (ncb.isRunning()) {
            now = System.currentTimeMillis();

            bi = grabScreen(robot, ncb.getInputRectangle());

            bi =
                    ImageUtils.scaleFast(bi,
                            outputDim.width,
                            outputDim.height);
            if (ncb.isBuffered())
                v.addElement(bi);
            else
                addImageToEncoder(age, bi);
            long delayBetweenFrames = (long)(ncb.getRecordSecondsPerFrame()*1000);
            delta = delayBetweenFrames -
                    (System.currentTimeMillis() - now);
            System.out.println("delta is" + delta);
            if (delta < 0) continue; // can't keep up!
            sleep(delta);
        }
        if (ncb.isBuffered()) {
            ProgressDialog pd = ProgressDialog.getInstance();
            pd.setTitle("saving images...");
            pd.setVisible(true);
            final int n = v.size();
            for (int i = 0; i < n; i++) {
                pd.setAmountDone(i * 100 / n);
                addImageToEncoder(age, (BufferedImage) v.elementAt(i));
            }
            pd.setVisible(false);
        }
    }
    private static void addImageToEncoder(AnimatedGifEncoder age,
                                          BufferedImage bi) {
        long now = System.currentTimeMillis();
        if (age.addFrame(bi) == false)
            In.message("problem adding image");
        long delay = System.currentTimeMillis() - now;
        System.out.println("screen encoding took:" + delay);
    }

    public static BufferedImage grabScreen(Robot robot, Rectangle rect) {
        BufferedImage bi;
        long now = System.currentTimeMillis();
        bi = robot.createScreenCapture(rect);
        long delay = System.currentTimeMillis() - now;
        System.out.println("screen capture took:" + delay);
        return bi;
    }

    /**
     * @param d the number of seconds to sleep.
     */
    public static void sleep(long d) {
        try {
            Thread.sleep(d);
        } catch (InterruptedException e) {
            e.printStackTrace();

        }

    }
}
