package video.neuquant;

import futils.Futil;
import gui.In;
import gui.dialogs.LabeledItemPanel;
import gui.dialogs.ModalDialog;
import gui.run.RunButton;
import gui.run.RunCheckBox;
import gui.run.RunSlider;
import gui.run.RunTextField;
import j2d.ImageUtils;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;

public class NequantDialog extends ModalDialog {
    NeuquantCaptureBean ncb;
    JLabel inputSizeLabel = null;

    public NequantDialog() {
        init();
    }

    private void init() {
        setTitle("NeQuantDialog");
        ncb = NeuquantCaptureBean.restore();
        final RunTextField outputFileTextField = getOutputFileTextField();
        LabeledItemPanel c = new LabeledItemPanel();


        c.addItem("localFile", outputFileTextField);
        c.addItem("setLocalFile", new RunButton("browse") {
            public void run() {
                File f = Futil.getWriteFile("select output file (.gif)");
                outputFileTextField.setText(f.getAbsolutePath());
                ncb.setOutputFile(f.getAbsolutePath());
            }
        });
        c.addItem("is Looped", new RunCheckBox("", ncb.isLooped()) {
            public void run() {
                ncb.setLooped(isSelected());
            }
        });
        c.addItem("buffer to memory", new RunCheckBox("", ncb.isBuffered()) {
            public void run() {
                ncb.setBuffered(isSelected());
            }
        });
        c.addItem("is silent", new RunCheckBox("", ncb.isSlient()) {
            public void run() {
                ncb.setSilent(isSelected());
            }
        });
        c.addItem("entire screen", new RunCheckBox("", ncb.isEntireScreen()) {
            public void run() {
                ncb.setEntireScreen(isSelected());
                if (!isSelected())
                    updateInputSize();
                if (isSelected()) {
                    ncb.setInputRectangle(ImageUtils.getFullScreen());
                    updateInputSizeLabel();
                }
            }
        });
        c.addItem("manual screen capture", new RunCheckBox("", ncb.isManual()) {
            public void run() {
                ncb.setManual(isSelected());
            }
        });
        Dimension d = ncb.getOutputSize();
        final JLabel outputSizeLabel = new JLabel(d.width + "x" + d.height);
        inputSizeLabel = getInputSizeLabel();
        c.addItem("input size (x,y)wxh: ", inputSizeLabel);
        c.addItem("output size:", outputSizeLabel);
        c.addItem("PlayBack sec/frame", new RunSlider(0, 10, (int) ncb.getPlayBackSecondsPerFrame()) {
            public void run() {
                ncb.setPlayBackSecondsPerFrame(getValue());
            }
        });
        c.addItem("Record sec/frame", new RunSlider(0, 10, (int) ncb.getRecordSecondsPerFrame()) {
            public void run() {
                ncb.setRecordSecondsPerFrame(getValue());
            }
        });
        c.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane jsp = new JScrollPane(c,JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        setContentPane(jsp);
    }

    private void updateInputSize() {
        Rectangle r = In.getRectangle("select the new input size");
        ncb.setInputRectangle(r);
        updateInputSizeLabel();
    }

    private void updateInputSizeLabel() {
        final Rectangle ir = ncb.getInputRectangle();
        inputSizeLabel.setText("(" + ir.x + "," + ir.y + ") " +
                ir.width + "x" + ir.height);
    }

    private JLabel getInputSizeLabel() {
        final Rectangle ir = ncb.getInputRectangle();
        final JLabel inputSizeLabel = new JLabel("(" + ir.x + "," + ir.y + ") " +
                ir.width + "x" + ir.height);
        return inputSizeLabel;
    }

    private RunTextField getOutputFileTextField() {
        return new RunTextField(ncb.getOutputFile(), 20) {
            public void run() {
                ncb.setOutputFile(getText());
            }
        };
    }

    /**
     * This method gets the values of the panel entry fields.
     *
     * @return an object containing the Customer data
     */
    public NeuquantCaptureBean getData() {
        return ncb;
    }

    public void okPressed() {
        if (isValidData()) {
            processOk();
        } else
            debugData();
    }

    private void processOk() {
        System.out.println("OK process!");
        ncb.save();
        System.out.println("Validate the data and capture...");
        //super.okPressed();
    }

    public void debugData() {
        In.message("data not valid! Model=" + ncb);
    }

    /**
     * This method checks that the data entered is valid.
     *
     * @return <code>true</code> if the data is valid, otherwise
     *         <code>false</code>
     */
    protected boolean isValidData() {
        return ncb.isValidData();
    }
}