package video.jvideo;

import futils.Futil;
import gui.In;
import j2d.ImageUtils;
import sound.recorder.AudioRecorder;
import sound.recorder.Recorder;
import utils.SystemUtils;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;


/**
 * DocJava, Inc. http://www.docjava.com Programmer: dlyon Date: Nov 23,
 * 2004 Time: 1:12:41 PM
 */
public class JVideo {


    public static String getStackTrace(Exception e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        e.printStackTrace(ps);
        try {
            baos.close();
        } catch (IOException e1) {
            e1.printStackTrace();

        }
        return new String(baos.toByteArray());
    }

    public static void main(String args[]) {
        int d = In.getInt(
                "enter delay between screen captures in seconds");
        File f = Futil.getDir(
                "select a file in an output directory");
        String format = ImageUtils.getImageIoFormat();
        int i = 10;

        do {
            long time = System.currentTimeMillis();
            final File audioOutputFile = new File(f.getAbsoluteFile()
                    +
                    SystemUtils.getDirectorySeparator()
                    + "img" + i + ".au");
            Recorder r = AudioRecorder.getRecorder(audioOutputFile);
            r.start();
            sleep(d);

            try {
                final File imageOutputFile = new File(f.getAbsoluteFile()
                        +
                        SystemUtils.getDirectorySeparator()
                        + "img" + i + "." + format);

                grabAndSaveAnImage(format,
                        imageOutputFile);
            } catch (IOException e) {
                e.printStackTrace();

            }
            i++;

            final long elapsedTime = System.currentTimeMillis() - time;
            if (elapsedTime < d * 1000)
                sleep((int) (d - elapsedTime / 1000));
            r.stopRecording();

        } while (true);


    }


    private static void sleep(int d) {
        try {
            Thread.sleep(d * 1000);
        } catch (InterruptedException e) {
            e.printStackTrace();

        }
    }

    public static void grabAndSaveAnImage(String format) {
        try {

            grabAndSaveAnImage(format,
                    Futil.getWriteFile("select a PNG output file"));
            In.message("saved");
        } catch (IOException e) {
            e.printStackTrace();

        }
    }


    public static void grabAndSaveAnImage(String format,
                                          File outputFile)
            throws IOException {
        // create screen shot
        BufferedImage image = captureWholeScreen();
        if (format.equals("tiff"))
            ImageUtils.saveAsTiff(image, outputFile);
        else
            ImageIO.write(image, format, outputFile);

    }


    private static BufferedImage captureWholeScreen() {
        try {
            return ImageUtils.captureWholeScreen();
        } catch (AWTException e) {
            e.printStackTrace();
        }
        return null;
    }

}