package video.jsnap;

import gui.In;
import gui.dialogs.ProgressDialog;
import j2d.ImageUtils;
import ip.gif.neuquantAnimation.AnimatedGifEncoder;
import sound.Oscillator;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.util.Vector;

import ip.gif.neuquantAnimation.AnimatedGifEncoder;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Nov 26, 2004
 * <p/>
 * Time: 9:05:43 AM
 */
public class OneFrameAtATimeCapture {

    public static void neuquantImageStreamToAFile(NeuquantCaptureBean ncb) {
        Dimension outputDim = ncb.getOutputSize();
        AnimatedGifEncoder age = new AnimatedGifEncoder();

        if (ncb.isLooped()) age.setRepeat(0);
        age.setDelay((int) ncb.getSecondsPerFrame() * 1000);
        age.setTransparent(Color.BLACK);
        age.start(ncb.getOutputFile());

        Vector imageBufferVector = new Vector();

        int frameNumber = 1;
        do {
            grabNextFrame(
                            ncb,
                            outputDim,
                            imageBufferVector,
                            age);
            frameNumber++;

        } while (In.getBoolean("ready for frame#" +
                frameNumber +
                "?"));
        if (ncb.isBuffered()) {
            compressBufferedImages(imageBufferVector, age);
        }
        age.finish();
    }

    private static void grabNextFrame(
                                     NeuquantCaptureBean ncb,
                                     Dimension outputDim,
                                     Vector imageBufferVector,
                                     AnimatedGifEncoder age) {
        BufferedImage bi = ImageUtils.captureScreen( ncb.getInputRectangle(), outputDim);

        if (ncb.isBuffered())
            imageBufferVector.addElement(bi);
        else
            addImageToEncoder(age, bi);

        beep(ncb);
    }

    private static void compressBufferedImages(Vector v,
                                               AnimatedGifEncoder age) {
        ProgressDialog pd = ProgressDialog.getInstance();
        pd.setTitle("saving images...");
        pd.setVisible(true);
        final int n = v.size();
        for (int i = 0; i < n; i++) {
            pd.setAmountDone(i * 100 / n);
            addImageToEncoder(age, (BufferedImage) v.elementAt(i));
        }
        pd.setVisible(false);
    }

    private static void beep(NeuquantCaptureBean ncb) {
        if (ncb.isSilentOnCapture()) return;
        Oscillator.beep();
    }


    private static void addImageToEncoder(AnimatedGifEncoder age,
                                          BufferedImage bi) {
        if (age.addFrame(bi) == false)
            In.message("problem adding image");
    }


}
