package video.jsnap;

import gui.In;
import j2d.ImageUtils;
import sound.Oscillator;
import utils.CompactJava;

import java.awt.*;
import java.io.*;
import java.util.prefs.Preferences;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Dec 8, 2004
 * Time: 8:06:45 PM
 */
public class NeuquantCaptureBean implements Serializable {
    private double secondsPerFrame = 1;
    private boolean isSilentOnCapture = false;
    private boolean isLooped = true;
    private boolean isBuffered = false;
    private boolean isEntireScreen = true;
    private boolean isScaled = false;
    private boolean running = true;
    private int numberOfFramesCaptured = 1;
    private String outputFile = null;
    private Rectangle inputRectangle = ImageUtils.getFullScreen();
    private Dimension outputSize =
            new Dimension((int) inputRectangle.getWidth(),
                    (int) inputRectangle.getHeight());
    private static String key = "NeuquantCaptureB";

    public String toXml() {
        return CompactJava.toXml(this) + "</java>";
    }

    public String toString() {
        return toXml();
    }
    public void scaleOuput(double d){
        outputSize.setSize(d*inputRectangle.getWidth(),
                d*inputRectangle.getHeight());
    }

    public static void main(String[] args) {
        NeuquantCaptureBean ncb = NeuquantCaptureBean.restore();
        System.out.println(ncb);
        ncb.setEntireScreen(false);
        ncb.setScaled(true);
        ncb.setBuffered(true);
        ncb.setSilentOnCapture(true);
        ncb.setLooped(false);
        ncb.save();
    }

    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save() {
        try {
            Preferences p = Preferences.userRoot();
            ByteArrayOutputStream baos = new
                    ByteArrayOutputStream();
            ObjectOutputStream oos = new
                    ObjectOutputStream(baos);
            oos.writeObject(this);
            baos.close();
            p.putByteArray(key, baos.toByteArray());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * restores the properties from the preference in
     * the user root.
     */
    public static NeuquantCaptureBean restore() {
        try {
            Preferences p = Preferences.userRoot();
            byte b [] = p.getByteArray(key, null);
            if (b == null)
                return new NeuquantCaptureBean();
            ByteArrayInputStream bais = new
                    ByteArrayInputStream(b);
            ObjectInputStream ois = new
                    ObjectInputStream(bais);
            Object o = ois.readObject();
            bais.close();
            return (NeuquantCaptureBean) o;
        } catch (IOException e) {
        } catch (ClassNotFoundException e) {
        }
        return new NeuquantCaptureBean();
    }

    public boolean isSilentOnCapture() {
        return isSilentOnCapture;
    }

    public void setSilentOnCapture(boolean silentOnCapture) {
        this.isSilentOnCapture = silentOnCapture;
        Oscillator.beep();
    }

    public double getSecondsPerFrame() {
        return secondsPerFrame;
    }

    public void setSecondsPerFrame(double secondsPerFrame) {
        this.secondsPerFrame = secondsPerFrame;
    }

    public boolean isLooped() {
        return isLooped;
    }

    public void setLooped(boolean looped) {
        this.isLooped = looped;
    }

    public boolean isBuffered() {
        return isBuffered;
    }

    public void setBuffered(boolean buffered) {
        this.isBuffered = buffered;
    }

    public boolean isEntireScreen() {
        return isEntireScreen;
    }

    public void setEntireScreen(boolean entireScreen) {
        this.isEntireScreen = entireScreen;
    }

    public Rectangle getInputRectangle() {
        return inputRectangle;
    }

    public void setInputRectangle(Rectangle inputRectangle) {
        this.inputRectangle = inputRectangle;
    }

    public Dimension getOutputSize() {
        return outputSize;
    }

    public void setOutputSize(Dimension outputSize) {
        this.outputSize = outputSize;
    }

    public String getOutputFile() {
        return outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    private boolean isNull(String s) {
        if (s.length() == 0) {
            In.message("Select a local file");
            return true;
        }
        if(!s.endsWith(".gif")){
            In.message("File is not a .gif");
            return true;
        }
        return false;
    }

    private boolean isNull(double d) {
        if (d == 0.0) {
            In.message("Dimensions cannot be 0 x 0");
            return true;
        }
        return false;
    }

    public boolean isValidData() {
        final boolean ofNull = isNull(outputFile);
        final boolean oswNull = isNull(outputSize.getWidth());
        final boolean oshNull = isNull(outputSize.getHeight());
        if (ofNull) {
            return false;
        }
        if (oswNull) {
            return false;
        }
        if (oshNull) {
            return false;
        }
        return true;
    }

    public boolean isScaled() {
        return isScaled;
    }

    public void setScaled(boolean scaled) {
        this.isScaled = scaled;
    }

    public int getNumberOfFramesCaptured() {
        return numberOfFramesCaptured;
    }

    public void setNumberOfFramesCaptured(int numberOfFramesCaptured) {
        this.numberOfFramesCaptured = numberOfFramesCaptured;
    }

    public boolean isRunning() {
        return running;
    }

    public void setRunning (boolean running) {
        this.running = running;
    }


}
