package video.jsnap;

import futils.Futil;
import gui.In;
import gui.dialogs.LabeledItemPanel;
import gui.run.RunButton;
import gui.run.RunCheckBox;
import gui.run.RunComboBox;
import gui.run.RunLabel;
import gui.run.RunSlider;
import gui.run.RunTextField;
import j2d.ImageUtils;

import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.util.Vector;

/**
 * This class demonstrates the usage of the StandardDialog class.
 */
public class JSnapDialog extends JDialog {
    NeuquantCaptureBean ncb = NeuquantCaptureBean.restore();
    private Rectangle inputRectangle = ImageUtils.getFullScreen();
    final RunLabel rlOutputSize = new RunLabel(ncb.getOutputSize().getWidth() +
            "x" +
            ncb.getOutputSize().getHeight());
    final RunLabel rlInputSize = new RunLabel(ncb.getInputRectangle().getWidth() +
            "x" +
            ncb.getInputRectangle().getHeight());
    final RunLabel rlLocation = new RunLabel("Y-point: " +
            ncb.getInputRectangle().y +
            ' ' +
            "X-point: " +
            ncb.getInputRectangle().x);

    public JSnapDialog() {
        init();
    }

    private void init() {
        setTitle("Neuquant Capture Dialog");
        setModal(false);

        LabeledItemPanel c = getOuputFilePanel();
        c.addItem("Select the sec/frame",
                new RunSlider(0, 10, (int) ncb.getSecondsPerFrame()) {
            public void run() {
                ncb.setSecondsPerFrame(getValue());
            }
        });
        addCheckBoxes(c);
        addSizeWidgets(c);

        c.addItem("Process", new RunButton("OK") {
            public void run() {
                ncb.setRunning(true);
                okPressed();
            }
        });
        c.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane jsp = new JScrollPane(c);
        setContentPane(jsp);
    }

    private void addSizeWidgets(LabeledItemPanel c) {
        final RunButton rbSetScale = new RunButton("set output height") {
            public void run() {
                Rectangle outputRect = In.getRectangle("set new output height");
                ncb.setOutputSize(new Dimension((int) outputRect.getWidth(),
                        (int) outputRect.getHeight()));
                updateLabels();
            }
        };
        c.addItem("Manually set output size", rbSetScale);
        RunComboBox rcbSampleOutput = getOutputScaleComboBox();
        c.addItem("Select fixed sampling output", rcbSampleOutput);
        c.addItem("Output Width x Height", rlOutputSize);
        c.addItem("Input Width x Height", rlInputSize);
        c.addItem("Input Coordinates", rlLocation);
    }

    private void addCheckBoxes(LabeledItemPanel c) {
        c.addItem("Looped output", new RunCheckBox("", ncb.isLooped()) {
            public void run() {
                ncb.setLooped(isSelected());
            }
        });
        c.addItem("Buffered image", new RunCheckBox("", ncb.isBuffered()) {
            public void run() {
                ncb.setBuffered(isSelected());
            }
        });
        c.addItem("Entire screen", new RunCheckBox("", ncb.isEntireScreen()) {
            public void run() {
                ncb.setEntireScreen(isSelected());
                if (isSelected()) {
                    inputRectangle = ImageUtils.getFullScreen();
                    ncb.setInputRectangle(inputRectangle);
                    ncb.setOutputSize(new Dimension((int) inputRectangle.getWidth(),
                            (int) inputRectangle.getHeight()));
                } else if (!isSelected()) {
                    inputRectangle = In.getRectangle("select active area");
                    ncb.setInputRectangle(inputRectangle);
                    ncb.setOutputSize(new Dimension((int) inputRectangle.getWidth(),
                            (int) inputRectangle.getHeight()));
                }
                updateLabels();
            }
        });
        c.addItem("isSilentOnCapture", new RunCheckBox("", ncb.isSilentOnCapture()) {
            public void run() {
                ncb.setSilentOnCapture(isSelected());
            }
        });
    }

    private LabeledItemPanel getOuputFilePanel() {
        final RunTextField outputFileTextField = getOutputFileTextField();
        LabeledItemPanel c = new LabeledItemPanel();
        c.addItem("Local file", outputFileTextField);
        c.addItem("Set Local File", new RunButton("Browse") {
            public void run() {
                File f = Futil.getWriteFile("Select local file");
                outputFileTextField.setText(f.getAbsolutePath());
                ncb.setOutputFile(f.getAbsolutePath());
            }
        });
        return c;
    }

    private RunComboBox getOutputScaleComboBox() {
        Vector v = new Vector();
        for (double t=1; t>=.1;t=t-.1)
            v.addElement(new Float(t));
        RunComboBox rcb = new RunComboBox(v) {
            public void run() {
                final Float f = (Float) getSelectedItem();
                ncb.scaleOuput(
                        f.floatValue());
                updateLabels();
            }
        };
        return rcb;
    }

    private void updateLabels() {
        final Rectangle inputRectangle = ncb.getInputRectangle();
        rlInputSize.setText(inputRectangle.getWidth() +
                "x" +
                inputRectangle.getHeight());
        final Dimension outputSize = ncb.getOutputSize();
        rlOutputSize.setText(outputSize.getWidth() +
                "x" +
                outputSize.getHeight());
        rlLocation.setText("Y-point: " +
                inputRectangle.y +
                ' ' +
                "X-point: " +
                inputRectangle.x);
    }

    private RunTextField getOutputFileTextField() {
        return new RunTextField(ncb.getOutputFile(), 20) {
            public void run() {
                ncb.setOutputFile(getText());
            }
        };
    }

    /**
     * This method gets the values of the panel entry fields.
     *
     * @return an object containing the Customer data
     */
    public NeuquantCaptureBean getData() {
        return ncb;
    }

    public void okPressed() {
        if (isValidData()) {
            processOk();
        } else
            debugData();
    }

    private void processOk() {
        setVisible(false);
        System.out.println("OK process!");
        ncb.save();
        System.out.println("Validate the data and capture...");

            OneFrameAtATimeCapture.neuquantImageStreamToAFile(ncb);
        
        In.message("Done with capture");
        hide();
        System.exit(0);
    }

    public void debugData() {
        In.message("Data not valid! Model: " + ncb);
    }

    /**
     * This method checks that the data entered is valid.
     *
     * @return <code>true</code> if the data is valid, otherwise
     *         <code>false</code>
     */
    protected boolean isValidData() {
        return ncb.isValidData();
    }

    public static void main(String[] args) {
        JSnapDialog dialog = new JSnapDialog();
        dialog.pack();
        dialog.show();
    }
}