package video.jmf;

import jmapps.ui.MessageDialog;
import jmapps.ui.ImageArea;

import java.awt.*;

/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Feb 2, 2005
 * Time: 3:38:47 PM
 * Copyright DocJava, 2005
 */
class RTPTimer extends Thread {
    JMStudio outer = null;
    private JMStudio jmStudio;

    public RTPTimer(JMStudio jmStudio, JMStudio outer) {
        this.jmStudio = jmStudio;
        this.outer = outer;
    }

    public void run() {
        MessageDialog dlg = null;
        String newtime;
        String answer = "";
        Image image = null;

        try {
            Thread.sleep(7000);
        } catch (InterruptedException ie) {
            return;
        }

        //System.out.println("killed = " + killed);
        //System.out.println("recvRTP = " + recvRTP);

        if (!jmStudio.killed && !jmStudio.recvRTP) {
            // popup a info diag
            image = ImageArea.loadImage("iconInfo.gif");
            dlg = new MessageDialog(outer, "Waiting for data", "7 seconds elasped", image, false, false);
            dlg.setLocationCenter();
            dlg.show();
        }

        int count = 7;
        while (!jmStudio.killed && !jmStudio.recvRTP && !Thread.currentThread().isInterrupted() && count < 60) {
            try {
                Thread.sleep(1000);
            } catch (InterruptedException ie) {
                if (dlg != null) {
                    dlg.dispose();
                    dlg = null;
                }
                return;
            }

            count++;
            newtime = new Integer(count).toString() + " seconds elasped";
            if (dlg != null)
                dlg.getTextView().setText(newtime);
        } // end of while

        if (!jmStudio.killed && !jmStudio.recvRTP && !Thread.currentThread().isInterrupted()) {

            answer = MessageDialog.createYesNoDialog(outer, "Waing for data", "You have been waiting for 60 secs. Continue to wait?");

        }

        if (!jmStudio.killed && !jmStudio.recvRTP && !Thread.currentThread().isInterrupted() && answer.equals("No")) {
            if (dlg != null) {
                dlg.dispose();
                dlg = null;
            }

            outer.killCurrentPlayer();
            return;
        }

        count = 60;
        while (!jmStudio.killed && !jmStudio.recvRTP && !Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(1000);
            } catch (InterruptedException ie) {
                if (dlg != null) {
                    dlg.dispose();
                    dlg = null;
                }
                return;
            }

            count++;
            newtime = new Integer(count).toString() + " seconds elasped";
            if (dlg != null)
                dlg.getTextView().setText(newtime);
        } // end of while


    } // end of run()
}
