package video;

import futils.Futil;
import futils.WordPrintMerge;
import gui.In;
import gui.dialogs.ProgressDialog;
import gui.run.RunJob;
import ip.color.Octree;
import ip.gif.gifAnimation.Gif89Encoder;
import j2d.ImageUtils;
import j2d.ShortImageBean;
import ip.gif.neuquantAnimation.AnimatedGifEncoder;
import utils.SystemUtils;

import javax.imageio.ImageIO;
import javax.media.j3d.Canvas3D;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.*;
import java.util.Vector;


/**
 * DocJava, Inc. http://www.docjava.com Programmer: dlyon Date: Nov 23,
 * 2004 Time: 1:12:41 PM
 */
public class ScreenCapture {
    Vector v = new Vector();
    RunJob rj = null;
    Octree ot = null;

    public static String getStackTrace(Exception e){
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        e.printStackTrace(ps);
        try {
            baos.close();
        } catch (IOException e1) {
            e1.printStackTrace();

        }
        return new String(baos.toByteArray());
    }

    public static void snap(Canvas3D canvas) {
        Dimension dim = canvas.getSize();
        Point p = canvas.getLocationOnScreen();
        File f = Futil.getWriteFile("select an output file");
        if (f == null) return;
        try {
            ScreenCapture.grabAndSaveAnImage("JPG", new Rectangle(p, dim), f);
        } catch (Exception e) {

        }

    }

    public static void main(String args[]) {
        int d = In.getInt("enter delay before screen capture");
        File f = Futil.getDir("select a file in an output directory");
        String format = ImageUtils.getImageIoFormat();
        int i = 10;
        Vector fileList = new Vector();
        do {
            int i1 = i;
            Rectangle rect =
                    In.getRectangle("select" +
                    " a an area to" +
                    " capture in "+d+" ms");
            sleep(d);

            try {
                final File outputFile = new File(f.getAbsoluteFile()
                                        +SystemUtils.getDirectorySeparator()
                                        +"img"+i1+"."+ format);
                fileList.addElement(outputFile);
                grabAndSaveAnImage(
                        format,
                        rect,
                        outputFile);
            } catch (AWTException e) {
                e.printStackTrace();



            } catch (IOException e) {
                e.printStackTrace();

            }
            i1++;
            i = i1;

        } while (In.getBoolean("ready to go again?"));
        if (In.getBoolean("want to synthesize a word print merge?")){
            try {
                wordPrintMerge(fileList);
            } catch (IOException e) {
                e.printStackTrace();

            }
        }

    }

    private static void wordPrintMerge(Vector fileList)
            throws IOException {
        File fl[] = new File[fileList.size()];
        fileList.copyInto(fl);
        WordPrintMerge.wordPrintMerge(fl);
    }

    private static void sleep(int d) {
        try {
            Thread.sleep(d);
        } catch (InterruptedException e) {
            e.printStackTrace();

        }
    }

    public static void grabAndSaveAnImage(String format) {
        try {

            grabAndSaveAnImage(format, In.getRectangle("select a capture area"),
                    Futil.getWriteFile("select a PNG output file"));
            In.message("saved");
        } catch (AWTException e) {
            e.printStackTrace();

        } catch (IOException e) {
            e.printStackTrace();

        }
    }

    public static void grabAndSaveGifAnimation() {
        ScreenCapture p = new ScreenCapture();
        System.out.println("Recording");
        int k = In.getInt("enter the number of frames to capture");
        p.record(k);    // number of seconds per frame
        System.out.println("images saved");
    }
    public static void grabAndSaveAnImage(String format,
                                          Rectangle rect,
                                          File outputFile)
            throws AWTException, IOException {
        // create screen shot
        Robot robot = new Robot();
        BufferedImage image = robot.createScreenCapture(rect);
        if (format.equals("tiff"))
            ImageUtils.saveAsTiff(image,outputFile);
            else
        ImageIO.write(image, format, outputFile);

    }


    private void record(int k) {
        for (int i = 0; i < k; i++)
            captureWholeScreenToBuffer();
        saveNeuquantImages();
    }

    public void snapAndSaveOneFrame() {
        captureWholeScreenToBuffer();
        saveScreen();
    }

    private void saveScreen() {
        Futil.setSwing(false);

        File f = Futil.getWriteFile("select and output file (gif)");
        ImageUtils.saveAsGif(makeGray(ImageUtils.getImage(
                (BufferedImage) v.elementAt(0))),
                f);

    }

    /**
     * @param img
     * @return a gray image
     */
    private Image makeGray(Image img) {
        ShortImageBean sib = new ShortImageBean(img);
        sib.gray();
        return sib.getImage();
    }

    /**
     * reduce the number of colors in an image sequence.
     *
     * @param NumberOfColors
     * @return an array of color reduced images.
     */
    private Image[] getColorReducedImages(int NumberOfColors) {
        ot = new Octree();
        final int n = v.size();
        Image imgs[] = new Image[n];
        System.out.println("begin color reduction process");
        ProgressDialog pd =  ProgressDialog.getInstance();
        int incr = 200 / n;
        pd.setSize(100, 100);
        pd.show();
        for (int i1 = 0; i1 < n; i1++) {
            pd.incrementValue(incr);
            ShortImageBean sib1 = new ShortImageBean(
                    ImageUtils.getImage((BufferedImage) v.elementAt(i1)));
            if (i1 == 0) {
                ot.octreeQuantization(sib1.getR(),
                        sib1.getB(),
                        sib1.getG(), NumberOfColors);
                continue;
            }
            ot.addImagesSeen(sib1.getR(), sib1.getB(), sib1.getG());

        }
        System.out.println("done with lut");
        for (int i = 0; i < n; i++) {
            ShortImageBean sib = new ShortImageBean(
                    ImageUtils.getImage((BufferedImage) v.elementAt(i)));
            ot.reMap(sib.getR(), sib.getG(), sib.getB());
            sib.swapGreenAndBlue();
            imgs[i] = sib.getImage();
            pd.incrementValue(incr);
        }
        System.out.println("colors reduced in image sequence");
        return imgs;

    }


    private void saveNeuquantImages()  {
        File f = Futil.getWriteFile("select gif output file");
        AnimatedGifEncoder age = new AnimatedGifEncoder();
        System.out.println("v.size="+v.size());
        age.setDelay(1000);
        In.message("writing worked=" + age.start(f.toString()));
        final int n = v.size();
        for (int i=0; i < n; i++) {
           boolean b= age.addFrame((BufferedImage)v.elementAt(i));
            if (b==false) In.message("problem adding image");
        }

        age.finish();
    }
    private void saveImages() throws IOException {
        File f = Futil.getWriteFile("select gif output file");
        int speed = 2; //fps
        //Image img [] = getImages();
        Image img[] = getColorReducedImages(240);
        int n = img.length;
        if (n == 0) return;
        FileOutputStream fos =
                Futil.getFileOutputStream(f);
        Gif89Encoder ge = new Gif89Encoder();
        for (int i = 1; i < n; i++) {
            ge.addFrame(img[i]);
            ge.setUniformDelay(Math.round(100 / speed));
            System.out.println("processed frame:" + i);
        }
        System.out.println("done!");
        ge.setLoopCount(true ?
                0 :
                1);
        ge.encode(fos);
        fos.close();
    }

    

    public void captureWholeScreenToBuffer() {
        v.addElement(captureWholeScreen());
    }

    private static BufferedImage captureWholeScreen() {
        try {
            return ImageUtils.captureWholeScreen();
        } catch (AWTException e) {
            e.printStackTrace();
        }
        return null;
    }

}