/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package utils;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Mar 9, 2005
 * <p/>
 * Time: 9:18:09 AM
 */
import gui.In;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * Runs a jar application from any url. Usage is 'java JarRunner url
 * [args..]' where url is the url of the jar file and args is optional
 * arguments to be passed to the application's main method.
 */
public class JarRunner {
    public static void resourceTester() {
         // http://show.docjava.com:8086/book/cgij/code/20050309Data.jar
        // can we get resources out of a large jar?
    }
    public static void main(String[] args) {
        try {
            String[] newArgs = {};
            URL url = new URL("http://show.docjava.com:8086/book/cgij/" +
                    "code/jnlp/dhry.Main.jar");
            run(url, newArgs);
        } catch (MalformedURLException e) {
            In.message(e);

        } catch (NoSuchMethodException e) {
            In.message(e);

        } catch (InvocationTargetException e) {
            In.message(e);

        } catch (ClassNotFoundException e) {
            In.message(e);

        }


    }

    public static void run(URL url, String[] newArgs)
            throws NoSuchMethodException,
                   InvocationTargetException,
                   ClassNotFoundException {
        // Create the class loader for the application jar file
        System.out.println("Now running the Jar Class loader on:"+url);
        JarClassLoader cl = new JarClassLoader(url);
        // Get the application's main class name
        String name = null;
        try {
            name = cl.getMainClassName();
        } catch (IOException e) {
            System.err.println("I/O error while loading JAR file:");
            e.printStackTrace();
            System.exit(1);
        }
        if (name == null) {
            In.message("Specified jar file does not contain a 'Main-Class'" +
                    " manifest attribute");
        }
        // Get arguments for the application
        System.out.println("now invoking main method in:"+url);

        cl.invokeClass(name, newArgs);

    }



}

