/*
 * Copyright (C) 1996 Emanuel Borsboom <manny@zerius.victoria.bc.ca>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package sound.zrs.synth;

import gui.In;
import gui.dialogs.ProgressDialog;
import sound.zrs.misc.Timeable;
import sound.zrs.misc.TimerThread;
import sound.zrs.synthgen.Synthesizer;
import sound.zrs.ui.Cancelable;
import sound.zrs.wave.Wave;
import sound.zrs.wave.WaveFrame;

class SynthesizeThread extends Thread implements Cancelable, Timeable {

    SynthFrame pa;

    Synthesizer synth;
    int samplingRate;
    int sampleCount;
    int currentSample;
    ProgressDialog progressDialog =  ProgressDialog.getInstance();

    TimerThread timerThread;

    SynthesizeThread(SynthFrame parent, Synthesizer synth,
                     int samplingRate, int sampleCount) {
        this.pa = parent;
        this.synth = synth;
        this.samplingRate = samplingRate;
        this.sampleCount = sampleCount;
        setPriority(Thread.NORM_PRIORITY - 1);

    }

    public void cancel() {
        progressDialog.hide();
        progressDialog.dispose();
        timerThread.setRunning(false);
        setRunning(false);
    }

    public void tick(TimerThread t) {
        progressDialog.setAmountDone(currentSample * 100 / sampleCount);
    }

    boolean running = true;

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void run() {

        timerThread = new TimerThread(this, 250);
        progressDialog.setSize(300,300);
        progressDialog.show();

        double[] wave = new double[sampleCount];
        currentSample = 0;

        timerThread.start();

        try {
            for (;
                 (currentSample < sampleCount) && running;
                 currentSample++)
                wave[currentSample] = synth.nextValue();
            displayWave(wave);
        } catch (Exception e) {
            In.message(e);
        } finally {
            progressDialog.hide();
            progressDialog.dispose();
            timerThread.setRunning(false);
        }

    }

    private void displayWave(double[] wave) {
        new WaveFrame(new Wave(wave,
                samplingRate,
                synth.maxValue > 1.0 ? synth.maxValue : 1.0),
                "Output from " + pa.name).show();
    }
}
