/*
 * Copyright (C) 1996 Emanuel Borsboom <manny@zerius.victoria.bc.ca>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package sound.zrs.synth;

import futils.Futil;
import gui.In;
import gui.run.RunButton;
import sound.zrs.misc.WindowRegistry;
import sound.zrs.ui.PropertiesDialog;
import sound.zrs.wave.Wave;
import sound.zrs.wave.WaveComponent;
import sound.zrs.wave.WaveFrame;

import javax.swing.*;
import java.awt.*;

class OscillatorPropertiesDialog
        extends PropertiesDialog {

    OscillatorBox pa;

    CheckboxGroup cbg;
    Checkbox sinBox;
    Checkbox triangleBox;
    Checkbox squareBox;
    Checkbox sawtoothBox;
    Checkbox waveBox;
    Checkbox interpolateBox;

    WaveComponent waveComponent;


    WaveFrame waveFrame = null;

    void addComponent(Component a, Panel p, GridBagLayout g,
                      GridBagConstraints c) {
        g.setConstraints(a, c);
        p.add(a);
    }

    OscillatorPropertiesDialog(OscillatorBox parent) {
        super("Oscillator Properties", parent);
        this.pa = parent;

        JPanel p2 = new JPanel();
        GridBagLayout gbl2 = new GridBagLayout();
        p2.setLayout(gbl2);

        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Panel p = new Panel();
        p.setLayout(gbl);
        c.gridx = c.gridy = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = GridBagConstraints.CENTER;
        addComponent(new Label("Wave Type"), p, gbl, c);
        cbg = new CheckboxGroup();
        c.gridy++;
        c.anchor = GridBagConstraints.WEST;
        c.insets.bottom = 0;
        c.insets.top = 0;
        addComponent(sinBox = new Checkbox("Sin", cbg,
                pa.type == OscillatorBox.SIN), p, gbl, c);
        c.gridy++;
        addComponent(triangleBox = new Checkbox("Triangle", cbg,
                pa.type == OscillatorBox.TRIANGLE), p, gbl, c);
        c.gridy++;
        addComponent(squareBox =
                new Checkbox("Square",
                        cbg,
                        pa.type == OscillatorBox.SQUARE),
                p,
                gbl,
                c);
        c.gridy++;
        addComponent(sawtoothBox = new Checkbox("Sawtooth", cbg,
                pa.type == OscillatorBox.SAWTOOTH), p, gbl, c);
        c.gridy++;
        c.insets.bottom = 2;
        addComponent(waveBox = new Checkbox("Custom", cbg,
                pa.type == OscillatorBox.WAVE), p, gbl, c);

        c.gridx = c.gridy = 0;
        c.insets = new Insets(2, 2, 2, 2);
        gbl2.setConstraints(p, c);
        p2.add(p);

        gbl = new GridBagLayout();
        c = new GridBagConstraints();
        p = new Panel();
        p.setLayout(gbl);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = GridBagConstraints.CENTER;
        addComponent(new Label("Custom Wave"), p, gbl, c);
        c.gridy++;
        c.insets.top = 0;
        c.weightx = c.weighty = 1.0;
        c.fill = GridBagConstraints.BOTH;
        addComponent(waveComponent =
                new WaveComponent((pa.wave == null) ?
                null :
                (Wave) pa.wave.clone(),
                        new Dimension(96, 38)),
                p,
                gbl,
                c);
        c.gridy++;
        c.insets.bottom = 0;
        c.weightx = c.weighty = 0.0;
        c.fill = GridBagConstraints.NONE;
        c.anchor = GridBagConstraints.NORTHWEST;
        addComponent(interpolateBox = new Checkbox("Interpolate"),
                p,
                gbl,
                c);
        interpolateBox.setState(pa.interpolate);
        c.gridy++;
        c.anchor = GridBagConstraints.CENTER;
        addComponent(new RunButton("Load ...") {
            public void run() {
                doLoadButton();
            }
        }, p, gbl, c);
        c.gridy++;
        addComponent(new RunButton("Update") {
            public void run() {
                doUpdateButton();
            }
        }, p, gbl, c);

        c.gridy++;
        c.insets.bottom = 2;
        addComponent(new RunButton("Edit ...") {
            public void run() {
                doEditButton();
            }


        }, p, gbl, c);

        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = c.weighty = 1.0;
        c.fill = GridBagConstraints.BOTH;
        gbl2.setConstraints(p, c);
        p2.add(p);

        getContentPane().add("Center", p2);
    }

    private void doEditButton() {
        waveFrame =
                new WaveFrame((waveComponent.getWave() == null) ?
                null :
                (Wave) waveComponent.getWave().clone(),
                        "Wave from Oscillator in " +
                pa.pa.pa.name);

        waveFrame.show();

    }


    public void apply() {
        Checkbox cur = cbg.getSelectedCheckbox();
        pa.wave = (waveComponent.getWave() == null) ?
                null :
                (Wave) waveComponent.getWave().clone();
        pa.interpolate = interpolateBox.getState();
        if (cur == sinBox)
            pa.type = OscillatorBox.SIN;
        else if (cur == squareBox)
            pa.type = OscillatorBox.SQUARE;
        else if (cur == triangleBox)
            pa.type = OscillatorBox.TRIANGLE;
        else if (cur == sawtoothBox)
            pa.type = OscillatorBox.SAWTOOTH;
        else if (cur == waveBox) {
            pa.type = OscillatorBox.WAVE;
        }
        pa.repaint();
    }


    private void doLoadButton() {
        WindowRegistry.saveCursors();
        WindowRegistry.setAllCursors(Cursor.WAIT_CURSOR);

        try {
            waveComponent.setWave(
                    new Wave(Futil.getFileInputStream("select au file")));
        } catch (Exception e) {
            In.message(e);
        } finally {

            WindowRegistry.restoreCursors();
        }

    }

    private void doUpdateButton() {
        if (waveFrame != null)
            waveComponent.setWave((waveFrame.getWave() == null) ?
                    null :
                    (Wave) waveFrame.getWave().clone());
    }

}
